/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.javac.internal.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

final class OsgiaasFileObject
extends SimpleJavaFileObject {
    private ByteArrayOutputStream byteCode;
    private final CharSequence source;

    OsgiaasFileObject(String simpleClassName, CharSequence source) {
        super(URI.create(simpleClassName + ".java"), JavaFileObject.Kind.SOURCE);
        this.source = source;
    }

    OsgiaasFileObject(String qualifiedClassName, JavaFileObject.Kind kind) {
        super(URI.create(qualifiedClassName), kind);
        this.source = null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.source == null) {
            throw new UnsupportedOperationException("getCharContent() not supported for this resource");
        }
        return this.source;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public OutputStream openOutputStream() {
        this.byteCode = new ByteArrayOutputStream();
        return this.byteCode;
    }

    byte[] getByteCode() {
        return this.byteCode.toByteArray();
    }

    @Override
    public String toString() {
        return "OsgiaasFileObject{name=" + this.getName() + '}';
    }
}

