/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.javac.internal.compiler;

import com.athaydes.osgiaas.api.env.ClassLoaderContext;
import com.athaydes.osgiaas.javac.internal.CompilerUtils;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasClassLoader;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasFileManager;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasFileObject;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiaasJavaCompiler {
    private static final Logger logger = LoggerFactory.getLogger(OsgiaasJavaCompiler.class);
    private final OsgiaasClassLoader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final OsgiaasFileManager javaFileManager;

    public OsgiaasJavaCompiler(ClassLoaderContext classLoaderContext) {
        this(classLoaderContext, Collections.emptyList());
    }

    public OsgiaasJavaCompiler(ClassLoaderContext classLoaderContext, Iterable<String> options) {
        if (this.compiler == null) {
            logger.error("The Java compiler is not present in the classpath");
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new OsgiaasClassLoader(classLoaderContext);
        this.diagnostics = new DiagnosticCollector();
        this.javaFileManager = new OsgiaasFileManager(this.compiler.getStandardFileManager(this.diagnostics, null, null), this.classLoader);
        this.options = new ArrayList<String>();
        if (options != null) {
            options.forEach(this.options::add);
        }
    }

    ClassLoaderContext getClassLoaderContext() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Optional<Class<T>> compile(String qualifiedClassName, CharSequence javaSource, PrintStream writer) {
        logger.info("Compiling {} from source code", (Object)qualifiedClassName);
        String className = CompilerUtils.simpleClassNameFrom(qualifiedClassName);
        String packageName = CompilerUtils.packageOf(qualifiedClassName);
        OsgiaasFileObject source = new OsgiaasFileObject(className, javaSource);
        PrintWriter errorWriter = new PrintWriter(writer);
        boolean ok = false;
        try {
            this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + ".java", source);
            JavaCompiler.CompilationTask task = this.compiler.getTask(errorWriter, this.javaFileManager, this.diagnostics, this.options, null, Collections.singleton(source));
            ok = task.call();
        }
        finally {
            if (!ok) {
                this.javaFileManager.removeFile(StandardLocation.SOURCE_PATH, packageName, className + ".java");
            }
            this.diagnostics.getDiagnostics().forEach(errorWriter::println);
            this.diagnostics = new DiagnosticCollector();
            errorWriter.flush();
        }
        if (ok) {
            try {
                return Optional.of(this.loadClass(qualifiedClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    private <T> Class<T> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.classLoader.loadClass(qualifiedClassName, true);
    }
}

