package com.athaydes.spockframework.report.internal

import com.athaydes.spockframework.report.SpockReportExtension
import groovy.util.logging.Slf4j
import groovy.xml.MarkupBuilder

/**
 *
 * User: Renato
 */
@Slf4j
abstract class AbstractHtmlCreator<T> {

    String css
    boolean doInlineCss = true
    String outputDirectory = ''
    boolean hideEmptyBlocks = false
    KnowsWhenAndWhoRanTest whenAndWho = new KnowsWhenAndWhoRanTest()
    String excludeToc = "false"

    private String resolvedCss

    abstract String cssDefaultName()

    String getCss() {
        if ( resolvedCss ) {
            return resolvedCss
        }
        if ( !css || css.trim().empty ) return ''
        resolvedCss = new CssResource( css, doInlineCss, new File( outputDirectory, cssDefaultName() ) ).text
    }

    String reportFor( T data ) {
        def writer = new StringWriter()
        def builder = new MarkupBuilder( new IndentPrinter( new PrintWriter( writer ), "" ) )
        builder.expandEmptyElements = true
        builder.html {
            head {
                meta( 'http-equiv': 'Content-Type', content: 'text/html; charset=utf-8' )
                if ( css && doInlineCss ) style css
                else if ( css ) link( rel: 'stylesheet', type: 'text/css', href: css )
            }
            body {
                h2 reportHeader( data )
                hr()
                writeSummary( builder, data )
                writeDetails( builder, data )
                hr()
                writeFooter( builder )
            }
        }
        '<!DOCTYPE html>' + writer.toString()
    }

    protected void writeFooter( MarkupBuilder builder ) {
        builder.div( 'class': 'footer' ) {
            mkp.yieldUnescaped(
                    "Generated by <a href='${SpockReportExtension.PROJECT_URL}'>Athaydes Spock Reports</a>" )
        }
    }

    abstract protected String reportHeader( T data )

    abstract protected void writeSummary( MarkupBuilder builder, T data )

    abstract protected void writeDetails( MarkupBuilder builder, T data )

}
