/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.ipadic;

import com.atilika.kuromoji.TokenizerBase;
import com.atilika.kuromoji.dict.CharacterDefinitions;
import com.atilika.kuromoji.dict.ConnectionCosts;
import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.dict.InsertedDictionary;
import com.atilika.kuromoji.dict.TokenInfoDictionary;
import com.atilika.kuromoji.dict.UnknownDictionary;
import com.atilika.kuromoji.ipadic.Token;
import com.atilika.kuromoji.trie.DoubleArrayTrie;
import com.atilika.kuromoji.util.ResourceResolver;
import com.atilika.kuromoji.util.SimpleResourceResolver;
import com.atilika.kuromoji.viterbi.TokenFactory;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer
extends TokenizerBase {
    public Tokenizer() {
        this(new Builder());
    }

    private Tokenizer(Builder builder) {
        this.configure(builder);
    }

    public List<Token> tokenize(String text) {
        return this.createTokenList(text);
    }

    public static class Builder
    extends TokenizerBase.Builder {
        private static final int DEFAULT_KANJI_LENGTH_THRESHOLD = 2;
        private static final int DEFAULT_OTHER_LENGTH_THRESHOLD = 7;
        private static final int DEFAULT_KANJI_PENALTY = 3000;
        private static final int DEFAULT_OTHER_PENALTY = 1700;
        private int kanjiPenaltyLengthTreshold = 2;
        private int kanjiPenalty = 3000;
        private int otherPenaltyLengthThreshold = 7;
        private int otherPenalty = 1700;
        private boolean nakaguroSplit = false;

        public Builder() {
            this.totalFeatures = 9;
            this.readingFeature = 7;
            this.partOfSpeechFeature = 0;
            this.tokenFactory = new TokenFactory<Token>(){

                public Token createToken(int wordId, String surface, ViterbiNode.Type type, int position, Dictionary dictionary) {
                    return new Token(wordId, surface, type, position, dictionary);
                }
            };
        }

        public Builder mode(TokenizerBase.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder kanjiPenalty(int lengthThreshold, int penalty) {
            this.kanjiPenaltyLengthTreshold = lengthThreshold;
            this.kanjiPenalty = penalty;
            return this;
        }

        public Builder otherPenalty(int lengthThreshold, int penalty) {
            this.otherPenaltyLengthThreshold = lengthThreshold;
            this.otherPenalty = penalty;
            return this;
        }

        public Builder isSplitOnNakaguro(boolean split) {
            this.nakaguroSplit = split;
            return this;
        }

        public Tokenizer build() {
            return new Tokenizer(this);
        }

        protected void loadDictionaries() {
            this.penalties = new ArrayList();
            this.penalties.add(this.kanjiPenaltyLengthTreshold);
            this.penalties.add(this.kanjiPenalty);
            this.penalties.add(this.otherPenaltyLengthThreshold);
            this.penalties.add(this.otherPenalty);
            this.resolver = new SimpleResourceResolver(((Object)((Object)this)).getClass());
            try {
                this.doubleArrayTrie = DoubleArrayTrie.newInstance((ResourceResolver)this.resolver);
                this.connectionCosts = ConnectionCosts.newInstance((ResourceResolver)this.resolver);
                this.tokenInfoDictionary = TokenInfoDictionary.newInstance((ResourceResolver)this.resolver);
                this.characterDefinitions = CharacterDefinitions.newInstance((ResourceResolver)this.resolver);
                if (this.nakaguroSplit) {
                    this.characterDefinitions.setCategories('\u30fb', new String[]{"SYMBOL"});
                }
                this.unknownDictionary = UnknownDictionary.newInstance((ResourceResolver)this.resolver, (CharacterDefinitions)this.characterDefinitions, (int)this.totalFeatures);
                this.insertedDictionary = new InsertedDictionary(this.totalFeatures);
            }
            catch (Exception ouch) {
                throw new RuntimeException("Could not load dictionaries.", ouch);
            }
        }
    }
}

