/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.common.collect;

import com.google.errorprone.annotations.DoNotMock;
import com.google.shade.common.annotations.GwtIncompatible;
import com.google.shade.common.collect.ElementTypesAreNonnullByDefault;
import com.google.shade.common.collect.Range;
import com.google.shade.javax.annotation.CheckForNull;
import java.util.Set;

@DoNotMock(value="Use ImmutableRangeSet or TreeRangeSet")
@ElementTypesAreNonnullByDefault
@GwtIncompatible
public interface RangeSet<C extends Comparable> {
    public boolean contains(C var1);

    @CheckForNull
    public Range<C> rangeContaining(C var1);

    public boolean intersects(Range<C> var1);

    public boolean encloses(Range<C> var1);

    public boolean enclosesAll(RangeSet<C> var1);

    public boolean enclosesAll(Iterable<Range<C>> var1);

    public boolean isEmpty();

    public Range<C> span();

    public Set<Range<C>> asRanges();

    public Set<Range<C>> asDescendingSetOfRanges();

    public RangeSet<C> complement();

    public RangeSet<C> subRangeSet(Range<C> var1);

    public void add(Range<C> var1);

    public void remove(Range<C> var1);

    public void clear();

    public void addAll(RangeSet<C> var1);

    public void addAll(Iterable<Range<C>> var1);

    public void removeAll(RangeSet<C> var1);

    public void removeAll(Iterable<Range<C>> var1);

    public boolean equals(@CheckForNull Object var1);

    public int hashCode();

    public String toString();
}

