/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.grpc.inprocess;

import com.google.shade.common.base.Preconditions;
import com.google.shade.grpc.ExperimentalApi;
import com.google.shade.grpc.inprocess.InProcessServer;
import com.google.shade.javax.annotation.Nullable;
import com.google.shade.javax.annotation.concurrent.GuardedBy;
import java.io.IOException;
import java.net.SocketAddress;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8626")
public final class AnonymousInProcessSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = -8567592561863414695L;
    @Nullable
    @GuardedBy(value="this")
    private InProcessServer server;

    @Nullable
    synchronized InProcessServer getServer() {
        return this.server;
    }

    synchronized void setServer(InProcessServer server) throws IOException {
        if (this.server != null) {
            throw new IOException("Server instance already registered");
        }
        this.server = server;
    }

    synchronized void clearServer(InProcessServer server) {
        Preconditions.checkState(this.server == server);
        this.server = null;
    }
}

