/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.grpc.internal;

import com.google.shade.common.annotations.VisibleForTesting;
import com.google.shade.common.base.Preconditions;
import com.google.shade.common.util.concurrent.ListenableFuture;
import com.google.shade.common.util.concurrent.SettableFuture;
import com.google.shade.grpc.CallOptions;
import com.google.shade.grpc.ClientStreamTracer;
import com.google.shade.grpc.InternalChannelz;
import com.google.shade.grpc.InternalLogId;
import com.google.shade.grpc.Metadata;
import com.google.shade.grpc.MethodDescriptor;
import com.google.shade.grpc.Status;
import com.google.shade.grpc.internal.ClientStream;
import com.google.shade.grpc.internal.ClientStreamListener;
import com.google.shade.grpc.internal.ClientTransport;
import com.google.shade.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

