/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.grpc.protobuf;

import com.google.shade.grpc.ExperimentalApi;
import com.google.shade.grpc.Metadata;
import com.google.shade.grpc.MethodDescriptor;
import com.google.shade.grpc.protobuf.lite.ProtoLiteUtils;
import com.google.shade.protobuf.ExtensionRegistry;
import com.google.shade.protobuf.Message;

public final class ProtoUtils {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1787")
    public static void setExtensionRegistry(ExtensionRegistry registry) {
        ProtoLiteUtils.setExtensionRegistry(registry);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        return ProtoLiteUtils.marshaller(defaultInstance);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10108")
    public static <T extends Message> MethodDescriptor.Marshaller<T> marshallerWithRecursionLimit(T defaultInstance, int recursionLimit) {
        return ProtoLiteUtils.marshallerWithRecursionLimit(defaultInstance, recursionLimit);
    }

    public static <T extends Message> Metadata.Key<T> keyForProto(T instance) {
        return Metadata.Key.of(instance.getDescriptorForType().getFullName() + "-bin", ProtoUtils.metadataMarshaller(instance));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4477")
    public static <T extends Message> Metadata.BinaryMarshaller<T> metadataMarshaller(T instance) {
        return ProtoLiteUtils.metadataMarshaller(instance);
    }

    private ProtoUtils() {
    }
}

