/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.common.collect;

import com.google.shade.common.annotations.GwtCompatible;
import com.google.shade.common.annotations.GwtIncompatible;
import com.google.shade.common.annotations.J2ktIncompatible;
import com.google.shade.common.collect.ImmutableMap;
import com.google.shade.common.collect.ImmutableSet;
import com.google.shade.common.collect.IndexedImmutableSet;
import com.google.shade.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableSet)this.map.entrySet()).asList().get(index)).getKey();
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        @GwtIncompatible
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

