/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CompatibleWith;
import com.google.errorprone.annotations.DoNotMock;
import com.google.shade.common.annotations.GwtCompatible;
import com.google.shade.common.collect.Multiset;
import com.google.shade.common.collect.ParametricNullness;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@DoNotMock(value="Use ImmutableMultimap, HashMultimap, or another implementation")
@GwtCompatible
public interface Multimap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(@CompatibleWith(value="K") @Nullable Object var1);

    public boolean containsValue(@CompatibleWith(value="V") @Nullable Object var1);

    public boolean containsEntry(@CompatibleWith(value="K") @Nullable Object var1, @CompatibleWith(value="V") @Nullable Object var2);

    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K var1, @ParametricNullness V var2);

    @CanIgnoreReturnValue
    public boolean remove(@CompatibleWith(value="K") @Nullable Object var1, @CompatibleWith(value="V") @Nullable Object var2);

    @CanIgnoreReturnValue
    public boolean putAll(@ParametricNullness K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> var1);

    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@ParametricNullness K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public Collection<V> removeAll(@CompatibleWith(value="K") @Nullable Object var1);

    public void clear();

    public Collection<V> get(@ParametricNullness K var1);

    public Set<K> keySet();

    public Multiset<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    public Map<K, Collection<V>> asMap();

    public boolean equals(@Nullable Object var1);

    public int hashCode();
}

