/*
 * Decompiled with CFR 0.152.
 */
package com.google.shade.grpc.internal;

import com.google.shade.common.annotations.VisibleForTesting;
import com.google.shade.common.base.MoreObjects;
import com.google.shade.common.base.Preconditions;
import com.google.shade.common.collect.ImmutableCollection;
import com.google.shade.common.collect.ImmutableList;
import com.google.shade.common.collect.Lists;
import com.google.shade.grpc.Attributes;
import com.google.shade.grpc.ConnectivityState;
import com.google.shade.grpc.ConnectivityStateInfo;
import com.google.shade.grpc.EquivalentAddressGroup;
import com.google.shade.grpc.LoadBalancer;
import com.google.shade.grpc.Status;
import com.google.shade.grpc.SynchronizationContext;
import com.google.shade.grpc.internal.BackoffPolicy;
import com.google.shade.grpc.internal.ExponentialBackoffPolicy;
import com.google.shade.grpc.internal.GrpcUtil;
import com.google.shade.grpc.internal.PickFirstLoadBalancerProvider;
import com.google.shade.javax.annotation.Nullable;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

final class PickFirstLeafLoadBalancer
extends LoadBalancer {
    private static final Logger log = Logger.getLogger(PickFirstLeafLoadBalancer.class.getName());
    @VisibleForTesting
    static final int CONNECTION_DELAY_INTERVAL_MS = 250;
    private final boolean enableHappyEyeballs = !PickFirstLeafLoadBalancer.isSerializingRetries() && PickFirstLoadBalancerProvider.isEnabledHappyEyeballs();
    private final LoadBalancer.Helper helper;
    private final Map<SocketAddress, SubchannelData> subchannels = new HashMap<SocketAddress, SubchannelData>();
    private final Index addressIndex = new Index(ImmutableList.of(), this.enableHappyEyeballs);
    private int numTf = 0;
    private boolean firstPass = true;
    @Nullable
    private SynchronizationContext.ScheduledHandle scheduleConnectionTask = null;
    private ConnectivityState rawConnectivityState = ConnectivityState.IDLE;
    private ConnectivityState concludedState = ConnectivityState.IDLE;
    private boolean notAPetiolePolicy = true;
    private final BackoffPolicy.Provider bkoffPolProvider = new ExponentialBackoffPolicy.Provider();
    private BackoffPolicy reconnectPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle reconnectTask = null;
    private final boolean serializingRetries = PickFirstLeafLoadBalancer.isSerializingRetries();

    PickFirstLeafLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
    }

    static boolean isSerializingRetries() {
        return GrpcUtil.getFlag("GRPC_SERIALIZE_RETRIES", false);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.rawConnectivityState == ConnectivityState.SHUTDOWN) {
            return Status.FAILED_PRECONDITION.withDescription("Already shut down");
        }
        Boolean isPetiolePolicy = (Boolean)resolvedAddresses.getAttributes().get(IS_PETIOLE_POLICY);
        this.notAPetiolePolicy = isPetiolePolicy == null || isPetiolePolicy == false;
        List<EquivalentAddressGroup> servers = resolvedAddresses.getAddresses();
        if (servers.isEmpty()) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        for (EquivalentAddressGroup eag : servers) {
            if (eag != null) continue;
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned address list with null endpoint. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        this.firstPass = true;
        List<EquivalentAddressGroup> cleanServers = PickFirstLeafLoadBalancer.deDupAddresses(servers);
        if (resolvedAddresses.getLoadBalancingPolicyConfig() instanceof PickFirstLeafLoadBalancerConfig) {
            PickFirstLeafLoadBalancerConfig config = (PickFirstLeafLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            if (config.shuffleAddressList != null && config.shuffleAddressList.booleanValue()) {
                Collections.shuffle(cleanServers, config.randomSeed != null ? new Random(config.randomSeed) : new Random());
            }
        }
        ImmutableCollection newImmutableAddressGroups = ((ImmutableList.Builder)ImmutableList.builder().addAll(cleanServers)).build();
        if (this.rawConnectivityState == ConnectivityState.READY || this.rawConnectivityState == ConnectivityState.CONNECTING) {
            SocketAddress previousAddress = this.addressIndex.getCurrentAddress();
            this.addressIndex.updateGroups((List<EquivalentAddressGroup>)((Object)newImmutableAddressGroups));
            if (this.addressIndex.seekTo(previousAddress)) {
                SubchannelData subchannelData = this.subchannels.get(previousAddress);
                subchannelData.getSubchannel().updateAddresses(this.addressIndex.getCurrentEagAsList());
                this.shutdownRemovedAddresses((ImmutableList<EquivalentAddressGroup>)newImmutableAddressGroups);
                return Status.OK;
            }
        } else {
            this.addressIndex.updateGroups((List<EquivalentAddressGroup>)((Object)newImmutableAddressGroups));
        }
        boolean noOldAddrs = this.shutdownRemovedAddresses((ImmutableList<EquivalentAddressGroup>)newImmutableAddressGroups);
        if (noOldAddrs) {
            this.rawConnectivityState = ConnectivityState.CONNECTING;
            this.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withNoResult()));
        }
        if (this.rawConnectivityState == ConnectivityState.READY) {
            this.rawConnectivityState = ConnectivityState.IDLE;
            this.updateBalancingState(ConnectivityState.IDLE, new RequestConnectionPicker(this));
        } else if (this.rawConnectivityState == ConnectivityState.CONNECTING || this.rawConnectivityState == ConnectivityState.TRANSIENT_FAILURE) {
            this.cancelScheduleTask();
            this.requestConnection();
        }
        return Status.OK;
    }

    private boolean shutdownRemovedAddresses(ImmutableList<EquivalentAddressGroup> newImmutableAddressGroups) {
        HashSet<SocketAddress> oldAddrs = new HashSet<SocketAddress>(this.subchannels.keySet());
        HashSet<SocketAddress> newAddrs = new HashSet<SocketAddress>();
        for (EquivalentAddressGroup endpoint : newImmutableAddressGroups) {
            newAddrs.addAll(endpoint.getAddresses());
        }
        for (SocketAddress oldAddr : oldAddrs) {
            if (newAddrs.contains(oldAddr)) continue;
            this.subchannels.remove(oldAddr).getSubchannel().shutdown();
        }
        return oldAddrs.isEmpty();
    }

    private static List<EquivalentAddressGroup> deDupAddresses(List<EquivalentAddressGroup> groups) {
        HashSet<SocketAddress> seenAddresses = new HashSet<SocketAddress>();
        ArrayList<EquivalentAddressGroup> newGroups = new ArrayList<EquivalentAddressGroup>();
        for (EquivalentAddressGroup group : groups) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>();
            for (SocketAddress addr : group.getAddresses()) {
                if (!seenAddresses.add(addr)) continue;
                addrs.add(addr);
            }
            if (addrs.isEmpty()) continue;
            newGroups.add(new EquivalentAddressGroup(addrs, group.getAttributes()));
        }
        return newGroups;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.rawConnectivityState == ConnectivityState.SHUTDOWN) {
            return;
        }
        for (SubchannelData subchannelData : this.subchannels.values()) {
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
        this.addressIndex.updateGroups(ImmutableList.of());
        this.rawConnectivityState = ConnectivityState.TRANSIENT_FAILURE;
        this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(error)));
    }

    void processSubchannelState(SubchannelData subchannelData, ConnectivityStateInfo stateInfo) {
        ConnectivityState newState = stateInfo.getState();
        if (subchannelData != this.subchannels.get(this.getAddress(subchannelData.subchannel))) {
            return;
        }
        if (newState == ConnectivityState.SHUTDOWN) {
            return;
        }
        if (newState == ConnectivityState.IDLE && subchannelData.state == ConnectivityState.READY) {
            this.helper.refreshNameResolution();
        }
        subchannelData.updateState(newState);
        if (this.rawConnectivityState == ConnectivityState.TRANSIENT_FAILURE || this.concludedState == ConnectivityState.TRANSIENT_FAILURE) {
            if (newState == ConnectivityState.CONNECTING) {
                return;
            }
            if (newState == ConnectivityState.IDLE) {
                this.requestConnection();
                return;
            }
        }
        switch (newState) {
            case IDLE: {
                this.addressIndex.reset();
                this.rawConnectivityState = ConnectivityState.IDLE;
                this.updateBalancingState(ConnectivityState.IDLE, new RequestConnectionPicker(this));
                break;
            }
            case CONNECTING: {
                this.rawConnectivityState = ConnectivityState.CONNECTING;
                this.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withNoResult()));
                break;
            }
            case READY: {
                this.shutdownRemaining(subchannelData);
                this.addressIndex.seekTo(this.getAddress(subchannelData.subchannel));
                this.rawConnectivityState = ConnectivityState.READY;
                this.updateHealthCheckedState(subchannelData);
                break;
            }
            case TRANSIENT_FAILURE: {
                if (this.addressIndex.isValid() && this.subchannels.get(this.addressIndex.getCurrentAddress()) == subchannelData) {
                    if (this.addressIndex.increment()) {
                        this.cancelScheduleTask();
                        this.requestConnection();
                    } else if (this.subchannels.size() >= this.addressIndex.size()) {
                        this.scheduleBackoff();
                    } else {
                        this.addressIndex.reset();
                        this.requestConnection();
                    }
                }
                if (!this.isPassComplete()) break;
                this.rawConnectivityState = ConnectivityState.TRANSIENT_FAILURE;
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(stateInfo.getStatus())));
                if (++this.numTf < this.addressIndex.size() && !this.firstPass) break;
                this.firstPass = false;
                this.numTf = 0;
                this.helper.refreshNameResolution();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported state:" + (Object)((Object)newState));
            }
        }
    }

    private void scheduleBackoff() {
        if (!this.serializingRetries) {
            return;
        }
        if (this.reconnectTask != null) {
            return;
        }
        if (this.reconnectPolicy == null) {
            this.reconnectPolicy = this.bkoffPolProvider.get();
        }
        long delayNanos = this.reconnectPolicy.nextBackoffNanos();
        class EndOfCurrentBackoff
        implements Runnable {
            EndOfCurrentBackoff() {
            }

            @Override
            public void run() {
                PickFirstLeafLoadBalancer.this.reconnectTask = null;
                PickFirstLeafLoadBalancer.this.addressIndex.reset();
                PickFirstLeafLoadBalancer.this.requestConnection();
            }
        }
        this.reconnectTask = this.helper.getSynchronizationContext().schedule(new EndOfCurrentBackoff(), delayNanos, TimeUnit.NANOSECONDS, this.helper.getScheduledExecutorService());
    }

    private void updateHealthCheckedState(SubchannelData subchannelData) {
        if (subchannelData.state != ConnectivityState.READY) {
            return;
        }
        if (this.notAPetiolePolicy || subchannelData.getHealthState() == ConnectivityState.READY) {
            this.updateBalancingState(ConnectivityState.READY, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withSubchannel(subchannelData.subchannel)));
        } else if (subchannelData.getHealthState() == ConnectivityState.TRANSIENT_FAILURE) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(subchannelData.healthStateInfo.getStatus())));
        } else if (this.concludedState != ConnectivityState.TRANSIENT_FAILURE) {
            this.updateBalancingState(subchannelData.getHealthState(), new Picker(LoadBalancer.PickResult.withNoResult()));
        }
    }

    private void updateBalancingState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (state == this.concludedState && (state == ConnectivityState.IDLE || state == ConnectivityState.CONNECTING)) {
            return;
        }
        this.concludedState = state;
        this.helper.updateBalancingState(state, picker);
    }

    @Override
    public void shutdown() {
        log.log(Level.FINE, "Shutting down, currently have {} subchannels created", this.subchannels.size());
        this.rawConnectivityState = ConnectivityState.SHUTDOWN;
        this.concludedState = ConnectivityState.SHUTDOWN;
        this.cancelScheduleTask();
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
        }
        this.reconnectPolicy = null;
        for (SubchannelData subchannelData : this.subchannels.values()) {
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
    }

    private void shutdownRemaining(SubchannelData activeSubchannelData) {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
        }
        this.reconnectPolicy = null;
        this.cancelScheduleTask();
        for (SubchannelData subchannelData : this.subchannels.values()) {
            if (subchannelData.getSubchannel().equals(activeSubchannelData.subchannel)) continue;
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
        activeSubchannelData.updateState(ConnectivityState.READY);
        this.subchannels.put(this.getAddress(activeSubchannelData.subchannel), activeSubchannelData);
    }

    @Override
    public void requestConnection() {
        if (!this.addressIndex.isValid() || this.rawConnectivityState == ConnectivityState.SHUTDOWN) {
            return;
        }
        SocketAddress currentAddress = this.addressIndex.getCurrentAddress();
        SubchannelData subchannelData = this.subchannels.get(currentAddress);
        if (subchannelData == null) {
            subchannelData = this.createNewSubchannel(currentAddress, this.addressIndex.getCurrentEagAttributes());
        }
        ConnectivityState subchannelState = subchannelData.getState();
        switch (subchannelState) {
            case IDLE: {
                subchannelData.subchannel.requestConnection();
                subchannelData.updateState(ConnectivityState.CONNECTING);
                this.scheduleNextConnection();
                break;
            }
            case CONNECTING: {
                this.scheduleNextConnection();
                break;
            }
            case TRANSIENT_FAILURE: {
                if (!this.serializingRetries) {
                    this.addressIndex.increment();
                    this.requestConnection();
                    break;
                }
                if (!this.addressIndex.isValid()) {
                    this.scheduleBackoff();
                    break;
                }
                subchannelData.subchannel.requestConnection();
                subchannelData.updateState(ConnectivityState.CONNECTING);
                break;
            }
        }
    }

    private void scheduleNextConnection() {
        if (!this.enableHappyEyeballs || this.scheduleConnectionTask != null && this.scheduleConnectionTask.isPending()) {
            return;
        }
        class StartNextConnection
        implements Runnable {
            StartNextConnection() {
            }

            @Override
            public void run() {
                PickFirstLeafLoadBalancer.this.scheduleConnectionTask = null;
                if (PickFirstLeafLoadBalancer.this.addressIndex.increment()) {
                    PickFirstLeafLoadBalancer.this.requestConnection();
                }
            }
        }
        this.scheduleConnectionTask = this.helper.getSynchronizationContext().schedule(new StartNextConnection(), 250L, TimeUnit.MILLISECONDS, this.helper.getScheduledExecutorService());
    }

    private void cancelScheduleTask() {
        if (this.scheduleConnectionTask != null) {
            this.scheduleConnectionTask.cancel();
            this.scheduleConnectionTask = null;
        }
    }

    private SubchannelData createNewSubchannel(SocketAddress addr, Attributes attrs) {
        HealthListener hcListener = new HealthListener();
        LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(Lists.newArrayList(new EquivalentAddressGroup(addr, attrs))).addOption(HEALTH_CONSUMER_LISTENER_ARG_KEY, hcListener).addOption(LoadBalancer.DISABLE_SUBCHANNEL_RECONNECT_KEY, this.serializingRetries).build());
        if (subchannel == null) {
            log.warning("Was not able to create subchannel for " + addr);
            throw new IllegalStateException("Can't create subchannel");
        }
        SubchannelData subchannelData = new SubchannelData(subchannel, ConnectivityState.IDLE);
        hcListener.subchannelData = subchannelData;
        this.subchannels.put(addr, subchannelData);
        Attributes scAttrs = subchannel.getAttributes();
        if (this.notAPetiolePolicy || scAttrs.get(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY) == null) {
            subchannelData.healthStateInfo = ConnectivityStateInfo.forNonError(ConnectivityState.READY);
        }
        subchannel.start(stateInfo -> this.processSubchannelState(subchannelData, stateInfo));
        return subchannelData;
    }

    private boolean isPassComplete() {
        if (this.subchannels.size() < this.addressIndex.size()) {
            return false;
        }
        for (SubchannelData sc : this.subchannels.values()) {
            if (sc.isCompletedConnectivityAttempt()) continue;
            return false;
        }
        return true;
    }

    private SocketAddress getAddress(LoadBalancer.Subchannel subchannel) {
        return subchannel.getAddresses().getAddresses().get(0);
    }

    @VisibleForTesting
    ConnectivityState getConcludedConnectivityState() {
        return this.concludedState;
    }

    @VisibleForTesting
    int getIndexLocation() {
        return this.addressIndex.activeElement;
    }

    @VisibleForTesting
    boolean isIndexValid() {
        return this.addressIndex.isValid();
    }

    public static final class PickFirstLeafLoadBalancerConfig {
        @Nullable
        public final Boolean shuffleAddressList;
        @Nullable
        final Long randomSeed;

        public PickFirstLeafLoadBalancerConfig(@Nullable Boolean shuffleAddressList) {
            this(shuffleAddressList, null);
        }

        PickFirstLeafLoadBalancerConfig(@Nullable Boolean shuffleAddressList, @Nullable Long randomSeed) {
            this.shuffleAddressList = shuffleAddressList;
            this.randomSeed = randomSeed;
        }
    }

    private static final class SubchannelData {
        private final LoadBalancer.Subchannel subchannel;
        private ConnectivityState state;
        private boolean completedConnectivityAttempt = false;
        private ConnectivityStateInfo healthStateInfo = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);

        public SubchannelData(LoadBalancer.Subchannel subchannel, ConnectivityState state) {
            this.subchannel = subchannel;
            this.state = state;
        }

        public LoadBalancer.Subchannel getSubchannel() {
            return this.subchannel;
        }

        public ConnectivityState getState() {
            return this.state;
        }

        public boolean isCompletedConnectivityAttempt() {
            return this.completedConnectivityAttempt;
        }

        private void updateState(ConnectivityState newState) {
            this.state = newState;
            if (newState == ConnectivityState.READY || newState == ConnectivityState.TRANSIENT_FAILURE) {
                this.completedConnectivityAttempt = true;
            } else if (newState == ConnectivityState.IDLE) {
                this.completedConnectivityAttempt = false;
            }
        }

        private ConnectivityState getHealthState() {
            return this.healthStateInfo.getState();
        }
    }

    @VisibleForTesting
    static final class Index {
        private List<UnwrappedEag> orderedAddresses;
        private int activeElement = 0;
        private boolean enableHappyEyeballs;

        Index(List<EquivalentAddressGroup> groups, boolean enableHappyEyeballs) {
            this.enableHappyEyeballs = enableHappyEyeballs;
            this.updateGroups(groups);
        }

        public boolean isValid() {
            return this.activeElement < this.orderedAddresses.size();
        }

        public boolean isAtBeginning() {
            return this.activeElement == 0;
        }

        public boolean increment() {
            if (!this.isValid()) {
                return false;
            }
            ++this.activeElement;
            return this.isValid();
        }

        public void reset() {
            this.activeElement = 0;
        }

        public SocketAddress getCurrentAddress() {
            if (!this.isValid()) {
                throw new IllegalStateException("Index is past the end of the address group list");
            }
            return this.orderedAddresses.get(this.activeElement).address;
        }

        public Attributes getCurrentEagAttributes() {
            if (!this.isValid()) {
                throw new IllegalStateException("Index is off the end of the address group list");
            }
            return this.orderedAddresses.get(this.activeElement).attributes;
        }

        public List<EquivalentAddressGroup> getCurrentEagAsList() {
            return Collections.singletonList(this.getCurrentEag());
        }

        private EquivalentAddressGroup getCurrentEag() {
            if (!this.isValid()) {
                throw new IllegalStateException("Index is past the end of the address group list");
            }
            return this.orderedAddresses.get(this.activeElement).asEag();
        }

        public void updateGroups(List<EquivalentAddressGroup> newGroups) {
            Preconditions.checkNotNull(newGroups, "newGroups");
            this.orderedAddresses = this.enableHappyEyeballs ? this.updateGroupsHE(newGroups) : this.updateGroupsNonHE(newGroups);
            this.reset();
        }

        public boolean seekTo(SocketAddress needle) {
            Preconditions.checkNotNull(needle, "needle");
            for (int i = 0; i < this.orderedAddresses.size(); ++i) {
                if (!this.orderedAddresses.get(i).address.equals(needle)) continue;
                this.activeElement = i;
                return true;
            }
            return false;
        }

        public int size() {
            return this.orderedAddresses.size();
        }

        private List<UnwrappedEag> updateGroupsNonHE(List<EquivalentAddressGroup> newGroups) {
            ArrayList<UnwrappedEag> entries = new ArrayList<UnwrappedEag>();
            for (int g = 0; g < newGroups.size(); ++g) {
                EquivalentAddressGroup eag = newGroups.get(g);
                for (int a = 0; a < eag.getAddresses().size(); ++a) {
                    SocketAddress addr = eag.getAddresses().get(a);
                    entries.add(new UnwrappedEag(eag.getAttributes(), addr));
                }
            }
            return entries;
        }

        private List<UnwrappedEag> updateGroupsHE(List<EquivalentAddressGroup> newGroups) {
            Boolean firstIsV6 = null;
            ArrayList<UnwrappedEag> v4Entries = new ArrayList<UnwrappedEag>();
            ArrayList<UnwrappedEag> v6Entries = new ArrayList<UnwrappedEag>();
            for (int g = 0; g < newGroups.size(); ++g) {
                EquivalentAddressGroup eag = newGroups.get(g);
                for (int a = 0; a < eag.getAddresses().size(); ++a) {
                    boolean isIpV4;
                    SocketAddress addr = eag.getAddresses().get(a);
                    boolean bl = isIpV4 = addr instanceof InetSocketAddress && ((InetSocketAddress)addr).getAddress() instanceof Inet4Address;
                    if (isIpV4) {
                        if (firstIsV6 == null) {
                            firstIsV6 = false;
                        }
                        v4Entries.add(new UnwrappedEag(eag.getAttributes(), addr));
                        continue;
                    }
                    if (firstIsV6 == null) {
                        firstIsV6 = true;
                    }
                    v6Entries.add(new UnwrappedEag(eag.getAttributes(), addr));
                }
            }
            return firstIsV6 != null && firstIsV6 != false ? this.interleave(v6Entries, v4Entries) : this.interleave(v4Entries, v6Entries);
        }

        private List<UnwrappedEag> interleave(List<UnwrappedEag> firstFamily, List<UnwrappedEag> secondFamily) {
            if (firstFamily.isEmpty()) {
                return secondFamily;
            }
            if (secondFamily.isEmpty()) {
                return firstFamily;
            }
            ArrayList<UnwrappedEag> result = new ArrayList<UnwrappedEag>(firstFamily.size() + secondFamily.size());
            for (int i = 0; i < Math.max(firstFamily.size(), secondFamily.size()); ++i) {
                if (i < firstFamily.size()) {
                    result.add(firstFamily.get(i));
                }
                if (i >= secondFamily.size()) continue;
                result.add(secondFamily.get(i));
            }
            return result;
        }

        private static final class UnwrappedEag {
            private final Attributes attributes;
            private final SocketAddress address;

            public UnwrappedEag(Attributes attributes, SocketAddress address) {
                this.attributes = attributes;
                this.address = address;
            }

            private EquivalentAddressGroup asEag() {
                return new EquivalentAddressGroup(this.address, this.attributes);
            }
        }
    }

    private final class RequestConnectionPicker
    extends LoadBalancer.SubchannelPicker {
        private final PickFirstLeafLoadBalancer pickFirstLeafLoadBalancer;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        RequestConnectionPicker(PickFirstLeafLoadBalancer pickFirstLeafLoadBalancer2) {
            this.pickFirstLeafLoadBalancer = Preconditions.checkNotNull(pickFirstLeafLoadBalancer2, "pickFirstLeafLoadBalancer");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                PickFirstLeafLoadBalancer.this.helper.getSynchronizationContext().execute(this.pickFirstLeafLoadBalancer::requestConnection);
            }
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult result) {
            this.result = Preconditions.checkNotNull(result, "result");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(Picker.class).add("result", this.result).toString();
        }
    }

    private final class HealthListener
    implements LoadBalancer.SubchannelStateListener {
        private SubchannelData subchannelData;

        private HealthListener() {
        }

        @Override
        public void onSubchannelState(ConnectivityStateInfo newState) {
            if (PickFirstLeafLoadBalancer.this.notAPetiolePolicy) {
                log.log(Level.WARNING, "Ignoring health status {0} for subchannel {1} as this is not under a petiole policy", new Object[]{newState, this.subchannelData.subchannel});
                return;
            }
            log.log(Level.FINE, "Received health status {0} for subchannel {1}", new Object[]{newState, this.subchannelData.subchannel});
            this.subchannelData.healthStateInfo = newState;
            if (PickFirstLeafLoadBalancer.this.addressIndex.isValid() && this.subchannelData == PickFirstLeafLoadBalancer.this.subchannels.get(PickFirstLeafLoadBalancer.this.addressIndex.getCurrentAddress())) {
                PickFirstLeafLoadBalancer.this.updateHealthCheckedState(this.subchannelData);
            }
        }
    }
}

