/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.permission;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class DeploymentPermissions
extends RootEntityPropertiesBuilder<DeploymentPermissionsProperties> {
    public static final String TYPE = "deployment permission";
    private BambooOidProperties deploymentOid;
    private String deploymentName;
    private Permissions permissions;

    @Override
    protected DeploymentPermissionsProperties build() {
        if (this.deploymentOid != null) {
            return new DeploymentPermissionsProperties(this.deploymentOid, (PermissionsProperties)EntityPropertiesBuilders.build(this.permissions));
        }
        return new DeploymentPermissionsProperties(this.deploymentName, (PermissionsProperties)EntityPropertiesBuilders.build(this.permissions));
    }

    public DeploymentPermissions(@NotNull BambooOid deploymentOid) {
        this((BambooOidProperties)EntityPropertiesBuilders.build(ImporterUtils.checkNotNull("deploymentOid", deploymentOid)));
    }

    public DeploymentPermissions(@NotNull BambooOidProperties deploymentOid) {
        ImporterUtils.checkNotNull("deploymentOid", deploymentOid);
        this.deploymentOid = deploymentOid;
    }

    public DeploymentPermissions(String deploymentProjectName) {
        ImporterUtils.checkNotBlank("deployment project name", deploymentProjectName);
        this.deploymentName = deploymentProjectName;
    }

    public DeploymentPermissions permissions(Permissions permissions) {
        ImporterUtils.checkNotNull("permissions", permissions);
        this.permissions = permissions;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public static DeploymentPermissions createForDeployment(@NotNull Deployment deployment) {
        if (deployment.getOid() != null) {
            return new DeploymentPermissions(deployment.getOid());
        }
        return new DeploymentPermissions(deployment.getName());
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        StringBuilder id = new StringBuilder();
        id.append(TYPE);
        id.append(" for deployment ");
        if (this.deploymentOid != null) {
            id.append(this.deploymentOid);
        } else {
            id.append(this.deploymentName);
        }
        return id.toString();
    }
}

