/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.task;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskProperties
implements EntityProperties {
    private final String description;
    private final boolean enabled;
    private final Collection<? extends RequirementProperties> requirements;
    private final Collection<? extends ConditionProperties> conditions;

    protected TaskProperties() {
        this("", true, Collections.emptyList(), Collections.emptyList());
    }

    public TaskProperties(String description, boolean enabled, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        this.description = description;
        this.enabled = enabled;
        this.requirements = Collections.unmodifiableList(new ArrayList<RequirementProperties>(requirements));
        this.conditions = Collections.unmodifiableList(new ArrayList<ConditionProperties>(conditions));
    }

    @NotNull
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<? extends RequirementProperties> getRequirements() {
        return this.requirements;
    }

    public Collection<? extends ConditionProperties> getConditions() {
        return this.conditions;
    }

    public EnumSet<Applicability> applicableTo() {
        return EnumSet.allOf(Applicability.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskProperties that = (TaskProperties)o;
        return this.isEnabled() == that.isEnabled() && Objects.equals(this.getAtlassianPlugin(), that.getAtlassianPlugin()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getRequirements(), that.getRequirements()) && Objects.equals(this.getConditions(), that.getConditions());
    }

    public int hashCode() {
        return Objects.hash(this.getAtlassianPlugin(), this.getDescription(), this.isEnabled());
    }

    @Override
    public void validate() {
    }

    public String toString() {
        return "TaskProperties{description='" + this.description + "', enabled=" + this.enabled + ", requirements=" + String.valueOf(this.requirements) + ", conditions=" + String.valueOf(this.conditions) + "}";
    }
}

