/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class VariableUtils {
    private static final Pattern VARIABLE_USAGE_PATTERN = Pattern.compile("\\$\\{([a-z]+)\\.([^\\$\\{\\}]+)\\}");
    private static final String[] PASSWORD_FIELD_NAMES = new String[]{"password", "sshKey", "secret", "passphrase"};

    private VariableUtils() {
    }

    public static boolean containsVariableUsage(@NotNull String text) {
        return VARIABLE_USAGE_PATTERN.matcher(text).find();
    }

    @NotNull
    public static List<VariableUsage> findVariableUsages(@NotNull String text) {
        Matcher matcher = VARIABLE_USAGE_PATTERN.matcher(text);
        ArrayList<VariableUsage> result = new ArrayList<VariableUsage>();
        while (matcher.find()) {
            result.add(new VariableUsage(matcher.group(1), matcher.group(2)));
        }
        return result;
    }

    public static boolean isPasswordVariable(@NotNull String variableKey) {
        for (String pattern : PASSWORD_FIELD_NAMES) {
            if (!StringUtils.containsIgnoreCase((CharSequence)variableKey, (CharSequence)pattern)) continue;
            return true;
        }
        return false;
    }

    public static class VariableUsage {
        private final String namespace;
        private final String name;

        public VariableUsage(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }
    }
}

