/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.common;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BambooStringUtils {
    public static final char CHAR_APOSTROPHE = '\'';
    public static final char CHAR_BACKSLASH = '\\';
    public static final char CHAR_DOUBLE_QUOTE = '\"';
    public static final char[] XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>', '\\'};
    public static final String XSS_RELATED_CHARACTERS_FIND_STR = "'\"\\\\<\\>";
    public static final char[] RELAXED_XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>'};
    public static final char[] SHELL_INJECTION_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '>', '<', ';', '`'};
    public static final String SHELL_INJECTION_DOLLAR_PARENTHESIS = "$(";

    private BambooStringUtils() {
    }

    public static boolean containsRelatedCharacters(@Nullable String string, @NotNull char[] characters) {
        return string != null && StringUtils.containsAny((CharSequence)string, (char[])characters);
    }

    public static boolean containsXssRelatedCharacters(@Nullable String string) {
        return BambooStringUtils.containsRelatedCharacters(string, XSS_RELATED_CHARACTERS);
    }

    public static boolean containsRelaxedXssRelatedCharacters(@Nullable String string) {
        return BambooStringUtils.containsRelatedCharacters(string, RELAXED_XSS_RELATED_CHARACTERS);
    }

    public static boolean containsShellInjectionRelatedCharacters(@Nullable String string) {
        return BambooStringUtils.containsRelatedCharacters(string, SHELL_INJECTION_RELATED_CHARACTERS) || string != null && string.contains(SHELL_INJECTION_DOLLAR_PARENTHESIS);
    }
}

