/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.repository;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.MapUtils;
import java.time.Duration;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class VcsChangeDetection
extends EntityPropertiesBuilder<VcsChangeDetectionProperties> {
    private boolean commitIsolationEnabled = false;
    private Map<String, Object> configuration;
    private String changesetFilterPatternRegex;
    private FileFilteringOption filterFilePatternOption = FileFilteringOption.NONE;
    private String filterFilePatternRegex;

    @Deprecated
    public VcsChangeDetection quietPeriodEnabled(boolean quietPeriodEnabled) {
        return this;
    }

    @Deprecated
    public VcsChangeDetection quietPeriod(Duration quietPeriod) {
        return this;
    }

    @Deprecated
    public VcsChangeDetection quietPeriodInSeconds(int quietPeriodInSeconds) {
        return this;
    }

    @Deprecated
    public VcsChangeDetection quietPeriodMaxRetries(int maxRetries) {
        return this;
    }

    public VcsChangeDetection commitIsolationEnabled(boolean commitIsolationEnabled) {
        this.commitIsolationEnabled = commitIsolationEnabled;
        return this;
    }

    public VcsChangeDetection configuration(@Nullable Map<String, Object> configuration) {
        this.configuration = MapUtils.copyOf(configuration);
        return this;
    }

    public VcsChangeDetection changesetFilterPatternRegex(@Nullable String changesetFilterPatternRegex) throws PropertiesValidationException {
        this.changesetFilterPatternRegex = changesetFilterPatternRegex;
        return this;
    }

    public VcsChangeDetection filterFilePatternOption(@Nullable FileFilteringOption filterFilePatternOption) throws PropertiesValidationException {
        this.filterFilePatternOption = filterFilePatternOption;
        return this;
    }

    public VcsChangeDetection filterFilePatternRegex(@Nullable String filterFilePatternRegex) throws PropertiesValidationException {
        this.filterFilePatternRegex = filterFilePatternRegex;
        return this;
    }

    @Override
    protected VcsChangeDetectionProperties build() throws PropertiesValidationException {
        return new VcsChangeDetectionProperties(this.commitIsolationEnabled, this.configuration, this.changesetFilterPatternRegex, this.filterFilePatternOption, this.filterFilePatternRegex);
    }

    public static enum FileFilteringOption {
        NONE,
        INCLUDE_ONLY,
        EXCLUDE_ALL;

    }
}

