/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.repository;

import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class VcsChangeDetectionValidator {
    private VcsChangeDetectionValidator() {
    }

    public static List<ValidationProblem> validate(@NotNull VcsChangeDetectionProperties vcsChangeDetectionProperties) {
        ValidationContext context = ValidationContext.of("VCS change detection");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        String changesetFilterRegex = vcsChangeDetectionProperties.getChangesetFilterPatternRegex();
        if (StringUtils.isNotBlank((CharSequence)changesetFilterRegex)) {
            try {
                Pattern.compile(changesetFilterRegex);
            }
            catch (PatternSyntaxException e) {
                errors.add(new ValidationProblem(context.with("Changeset filter"), "Exclude changesets regexp '%s' must contain valid regexp - %s", changesetFilterRegex, e.getMessage()));
            }
        }
        VcsChangeDetection.FileFilteringOption filterPatternOption = vcsChangeDetectionProperties.getFilterFilePatternOption();
        if (EnumSet.of(VcsChangeDetection.FileFilteringOption.INCLUDE_ONLY, VcsChangeDetection.FileFilteringOption.EXCLUDE_ALL).contains((Object)filterPatternOption)) {
            String patternRegex = vcsChangeDetectionProperties.getFilterFilePatternRegex();
            if (StringUtils.isNotEmpty((CharSequence)patternRegex)) {
                try {
                    Pattern.compile(patternRegex);
                }
                catch (PatternSyntaxException e) {
                    errors.add(new ValidationProblem(context.with("File pattern"), "File pattern regexp '%s' must contain valid regexp - %s", patternRegex, e.getMessage()));
                }
            } else {
                errors.add(new ValidationProblem(context.with("File pattern"), "File pattern regexp is required when filterFilePatternOption is used."));
            }
        }
        return errors;
    }
}

