/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.configuration;

import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.model.plan.configuration.HangingBuildConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class HangingBuildConfiguration
extends PluginConfiguration<HangingBuildConfigurationProperties> {
    private static final double DEFAULT_MULTIPLIER = 2.0;
    private static final int DEFAULT_LOG_TIME = 10;
    private static final int DEFAULT_QUEUE_TIMEOUT_MINUTES = 120;
    private boolean enabled = true;
    private int minutesBetweenLogs = 10;
    private int minutesQueueTimeout = 120;
    private double multiplier = 2.0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMinutesBetweenLogs() {
        return this.minutesBetweenLogs;
    }

    public int getMinutesQueueTimeout() {
        return this.minutesQueueTimeout;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public HangingBuildConfiguration enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public HangingBuildConfiguration minutesBetweenLogs(int minutesBetweenLogs) {
        ImporterUtils.checkThat(ValidationContext.of("minutesBetweenLogs"), minutesBetweenLogs > 0, "Minutes between logs must be greater than 0.", new Object[0]);
        this.minutesBetweenLogs = minutesBetweenLogs;
        return this;
    }

    public HangingBuildConfiguration minutesQueueTimeout(int minutesQueueTimeout) {
        ImporterUtils.checkThat(ValidationContext.of("minutesQueueTimeout"), minutesQueueTimeout > 0, "Minutes queue timeout must be greater than 0.", new Object[0]);
        this.minutesQueueTimeout = minutesQueueTimeout;
        return this;
    }

    public HangingBuildConfiguration multiplier(double multiplier) {
        ImporterUtils.checkThat(ValidationContext.of("multiplier"), multiplier > 0.0, "Build time multiplier must be greater than 0.", new Object[0]);
        this.multiplier = multiplier;
        return this;
    }

    @Override
    @NotNull
    protected HangingBuildConfigurationProperties build() {
        return new HangingBuildConfigurationProperties(this.enabled, this.minutesBetweenLogs, this.minutesQueueTimeout, this.multiplier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HangingBuildConfiguration that = (HangingBuildConfiguration)o;
        return this.enabled == that.enabled && this.minutesBetweenLogs == that.minutesBetweenLogs && this.minutesQueueTimeout == that.minutesQueueTimeout && Double.compare(that.multiplier, this.multiplier) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.enabled, this.minutesBetweenLogs, this.minutesQueueTimeout, this.multiplier);
    }
}

