/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.exceptions;

import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BambooSpecsPublishingException
extends RuntimeException {
    @Nullable
    private final ErrorType errorType;
    @Nullable
    private final String debugMessage;

    public BambooSpecsPublishingException(@NotNull RootEntityPropertiesBuilder<?> entityProperties, @Nullable ErrorType errorType, @Nullable String message, @Nullable String debugMessage, @Nullable Throwable cause) {
        super(BambooSpecsPublishingException.formatErrorMessage(entityProperties, message), cause);
        this.errorType = errorType;
        this.debugMessage = debugMessage;
    }

    @Nullable
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    @NotNull
    public String getMessage() {
        return super.getMessage();
    }

    @Nullable
    public String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    @Nullable
    public Throwable getCause() {
        return super.getCause();
    }

    @NotNull
    private static String formatErrorMessage(@NotNull RootEntityPropertiesBuilder<?> entityProperties, @Nullable String message) {
        return message != null ? String.format("An error occurred while publishing %s: %s", entityProperties.humanReadableId(), message) : String.format("An error occurred while publishing %s", entityProperties.humanReadableId());
    }

    public static enum ErrorType {
        UNKNOWN_HOST,
        CONNECTION_ERROR,
        PROTOCOL_ERROR,
        UNAUTHORIZED;

    }
}

