/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.configuration;

import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class HangingBuildConfigurationProperties
implements PluginConfigurationProperties {
    private static final AtlassianModuleProperties ATLASSIAN_MODULE = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.system.additionalBuildConfiguration:buildHangingConfig");
    private boolean enabled;
    private int minutesBetweenLogs;
    private int minutesQueueTimeout;
    private double multiplier;

    private HangingBuildConfigurationProperties() {
    }

    public HangingBuildConfigurationProperties(boolean enabled, int minutesBetweenLogs, int minutesQueueTimeout, double multiplier) {
        this.enabled = enabled;
        this.minutesBetweenLogs = minutesBetweenLogs;
        this.minutesQueueTimeout = minutesQueueTimeout;
        this.multiplier = multiplier;
        this.validate();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMinutesBetweenLogs() {
        return this.minutesBetweenLogs;
    }

    public int getMinutesQueueTimeout() {
        return this.minutesQueueTimeout;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    @Override
    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE;
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Hanging build configuration");
        ImporterUtils.checkThat(context.with("multiplier"), this.multiplier > 0.0, "Build time multiplier should be greater than 0", new Object[0]);
        ImporterUtils.checkThat(context.with("minutesBetweenLogs"), this.minutesBetweenLogs > 0, "Minutes between logs should be greater than 0", new Object[0]);
        ImporterUtils.checkThat(context.with("minutesQueueTimeout"), this.minutesQueueTimeout > 0, "Minutes in queue timeout should be greater than 0", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HangingBuildConfigurationProperties that = (HangingBuildConfigurationProperties)o;
        return this.enabled == that.enabled && this.minutesBetweenLogs == that.minutesBetweenLogs && this.minutesQueueTimeout == that.minutesQueueTimeout && Double.compare(that.multiplier, this.multiplier) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.minutesBetweenLogs, this.minutesQueueTimeout, this.multiplier);
    }
}

