/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.credentials;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.SharedCredentialsValidator;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public abstract class SharedCredentialsProperties
implements EntityProperties {
    private final String name;
    private final BambooOidProperties oid;

    protected SharedCredentialsProperties() {
        this.name = null;
        this.oid = null;
    }

    protected SharedCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
    }

    @NotNull
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedCredentialsProperties that = (SharedCredentialsProperties)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getOid(), that.getOid());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getOid());
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("name", this.name);
        ImporterUtils.checkNoErrors(SharedCredentialsValidator.validate(this));
    }
}

