package com.atlassian.bamboo.specs.api.builders.plan.configuration;

import com.atlassian.bamboo.specs.api.model.plan.configuration.AllOtherPluginsConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

/***
 * Builder for all the plugins that don't have proper builders. This builder passes configuration as a map of options.
 * Please, refer to the plugin documentation to find list of keys recognized by that plugin.
 */
public class AllOtherPluginsConfiguration extends PluginConfiguration<AllOtherPluginsConfigurationProperties> {

    private Map<String, Object> configuration = new HashMap<>();

    public AllOtherPluginsConfiguration() {
    }

    /***
     * Specifies the configuration of plugins.
     */
    public AllOtherPluginsConfiguration configuration(@NotNull Map<String, Object> configuration) {
        ImporterUtils.checkNotNull("configuration", configuration);
        this.configuration = configuration;
        return this;
    }

    @Override
    protected AllOtherPluginsConfigurationProperties build() {
        return new AllOtherPluginsConfigurationProperties(configuration);
    }
}
