/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.specs.api.builders.notification.EmptyNotificationsList;
import com.atlassian.bamboo.specs.api.builders.notification.Notification;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.plan.Stage;
import com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchManagement;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.AllOtherPluginsConfiguration;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.Dependencies;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.EmptyDependenciesList;
import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.builders.repository.PlanRepositoryLink;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.notification.EmptyNotificationsListProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.rsbs.RunnerSettings;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Plan
extends RootEntityPropertiesBuilder<PlanProperties> {
    public static final String TYPE = "plan";
    private BambooKeyProperties key;
    private BambooOidProperties oid;
    private String name;
    private String description = "";
    private ProjectProperties project;
    private List<StageProperties> stages = new ArrayList<StageProperties>();
    private List<PlanRepositoryLinkProperties> repositories = new ArrayList<PlanRepositoryLinkProperties>();
    private List<TriggerProperties> triggers = new ArrayList<TriggerProperties>();
    private List<VariableProperties> variables = new ArrayList<VariableProperties>();
    private boolean enabled = true;
    private PlanBranchManagementProperties planBranchManagement;
    private DependenciesProperties dependencies;
    private Map<String, PluginConfigurationProperties> pluginConfigurations = new LinkedHashMap<String, PluginConfigurationProperties>();
    private List<NotificationProperties> notifications = new ArrayList<NotificationProperties>();
    private Boolean forceStopHungBuilds = null;

    public Plan(@NotNull Plan copy) {
        this.key = copy.key;
        this.oid = copy.oid;
        this.name = copy.name;
        this.description = copy.description;
        this.project = copy.project;
        this.stages.addAll(copy.stages);
        this.repositories.addAll(copy.repositories);
        this.triggers.addAll(copy.triggers);
        this.variables.addAll(copy.variables);
        this.enabled = copy.enabled;
        this.planBranchManagement = copy.planBranchManagement;
        this.dependencies = copy.dependencies;
        this.pluginConfigurations.putAll(copy.pluginConfigurations);
        this.notifications.addAll(copy.notifications);
        this.forceStopHungBuilds = copy.forceStopHungBuilds;
    }

    public Plan(@NotNull Project project, @NotNull String name, @NotNull String key) throws PropertiesValidationException {
        this(project, name, key != null ? new BambooKey(key) : null);
    }

    public Plan(@NotNull Project project, @NotNull String name, @NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("project", project);
        ImporterUtils.checkNotNull("name", name);
        ImporterUtils.checkNotNull("key", key);
        this.project = (ProjectProperties)EntityPropertiesBuilders.build(project);
        this.name = name;
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
        this.planBranchManagement(new PlanBranchManagement());
        this.dependencies(new Dependencies());
    }

    public Plan inProject(@NotNull Project project) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("project", project);
        this.project = (ProjectProperties)EntityPropertiesBuilders.build(project);
        return this;
    }

    public Plan name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
        return this;
    }

    public Plan key(@Nullable String key) throws PropertiesValidationException {
        return this.key(key != null ? new BambooKey(key) : null);
    }

    public Plan key(@Nullable BambooKey key) throws PropertiesValidationException {
        this.key = key != null ? (BambooKeyProperties)EntityPropertiesBuilders.build(key) : null;
        return this;
    }

    public Plan oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public Plan oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return this;
    }

    public Plan description(@Nullable String description) throws PropertiesValidationException {
        this.description = description;
        return this;
    }

    public Plan stages(Stage ... stages) {
        ImporterUtils.checkNotNull("stages", stages);
        Arrays.stream(stages).map(EntityPropertiesBuilders::build).forEach(this.stages::add);
        return this;
    }

    public Plan planRepositories(VcsRepository<?, ?> ... repositories) {
        ImporterUtils.checkNotNull("repositories", repositories);
        Arrays.stream(repositories).map(repo -> new PlanRepositoryLink().localRepositoryDefinition((VcsRepository<?, ?>)repo)).map(EntityPropertiesBuilders::build).forEach(this.repositories::add);
        return this;
    }

    public Plan linkedRepositories(String ... repositoriesNames) {
        ImporterUtils.checkNotNull("repositoriesNames", repositoriesNames);
        Arrays.stream(repositoriesNames).map(VcsRepositoryIdentifier::new).map(PlanRepositoryLink::linkToGlobalRepository).map(EntityPropertiesBuilders::build).forEach(this.repositories::add);
        return this;
    }

    @Deprecated
    public Plan linkedRepositories(VcsRepositoryIdentifier ... repositories) {
        ImporterUtils.checkNotNull("repositories", repositories);
        Arrays.stream(repositories).map(PlanRepositoryLink::linkToGlobalRepository).map(EntityPropertiesBuilders::build).forEach(this.repositories::add);
        return this;
    }

    public Plan triggers(Trigger<?, ?> ... triggers) {
        ImporterUtils.checkNotNull("triggers", triggers);
        for (Trigger<?, ?> t : triggers) {
            TriggerProperties trigger = (TriggerProperties)EntityPropertiesBuilders.build(t);
            if (!trigger.applicableTo().contains((Object)Applicability.PLANS)) {
                throw new PropertiesValidationException("Trigger " + t.getClass().getSimpleName() + " is not available in plans");
            }
            this.triggers.add(trigger);
        }
        return this;
    }

    public Plan variables(Variable ... variables) {
        ImporterUtils.checkNotNull("variables", variables);
        Arrays.stream(variables).map(EntityPropertiesBuilders::build).forEach(this.variables::add);
        return this;
    }

    public Plan enabled(boolean enabled) throws PropertiesValidationException {
        this.enabled = enabled;
        return this;
    }

    public Plan planBranchManagement(@NotNull PlanBranchManagement planBranchManagement) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("planBranchManagement", planBranchManagement);
        this.planBranchManagement = (PlanBranchManagementProperties)EntityPropertiesBuilders.build(planBranchManagement);
        return this;
    }

    public Plan dependencies(@NotNull Dependencies dependencies) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("dependencies", dependencies);
        this.dependencies = (DependenciesProperties)EntityPropertiesBuilders.build(dependencies);
        return this;
    }

    @Deprecated
    public Plan noDependencies() {
        return this.dependencies(new EmptyDependenciesList());
    }

    public Plan pluginConfigurations(PluginConfiguration<? extends PluginConfigurationProperties> ... pluginConfigurations) {
        ImporterUtils.checkNotNull("pluginConfigurations", pluginConfigurations);
        for (PluginConfiguration<? extends PluginConfigurationProperties> pluginConfiguration : pluginConfigurations) {
            if (pluginConfiguration == null) continue;
            this.putPluginConfiguration(pluginConfiguration);
        }
        return this;
    }

    @Deprecated
    public Plan noPluginConfigurations() {
        return this.pluginConfigurations(new AllOtherPluginsConfiguration());
    }

    private void putPluginConfiguration(PluginConfiguration<?> pluginConfiguration) {
        PluginConfigurationProperties pluginConfigurationProperties = (PluginConfigurationProperties)EntityPropertiesBuilders.build(pluginConfiguration);
        this.pluginConfigurations.put(pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey(), pluginConfigurationProperties);
    }

    public Plan notifications(Notification ... notifications) {
        ImporterUtils.checkNotNull("notifications", notifications);
        Arrays.stream(notifications).map(EntityPropertiesBuilders::build).forEach(notification -> {
            ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
            if (!(notification instanceof EmptyNotificationsListProperties)) {
                if (!notification.getType().applicableTo().contains((Object)Applicability.PLANS)) {
                    problems.add(new ValidationProblem(String.format("Can't add notification because notification type (%s) is not available in plans", notification.getType().getAtlassianPlugin().getCompleteModuleKey())));
                }
                for (NotificationRecipientProperties recipient : notification.getRecipients()) {
                    if (recipient.applicableTo().contains((Object)Applicability.PLANS)) continue;
                    problems.add(new ValidationProblem(String.format("Can't add notification because notification recipient (%s) is not available in plans", recipient.getAtlassianPlugin().getCompleteModuleKey())));
                }
            }
            if (!problems.isEmpty()) {
                throw new PropertiesValidationException(problems);
            }
            this.notifications.add((NotificationProperties)notification);
        });
        return this;
    }

    @Deprecated
    public Plan noNotifications() {
        return this.notifications(new EmptyNotificationsList());
    }

    public Plan forceStopHungBuilds() {
        this.forceStopHungBuilds = true;
        return this;
    }

    public Plan ignoreHungBuilds() {
        this.forceStopHungBuilds = false;
        return this;
    }

    @NotNull
    public PlanIdentifier getIdentifier() {
        if (this.oid != null) {
            PlanIdentifier planIdentifier = new PlanIdentifier(new BambooOid(this.oid.getOid()));
            if (this.project != null) {
                planIdentifier.projectKey(this.project.getKey().getKey());
            }
            if (this.key != null) {
                planIdentifier.key(this.key.getKey());
            }
            return planIdentifier;
        }
        if (this.project != null && this.key != null) {
            PlanIdentifier planIdentifier = new PlanIdentifier(this.project.getKey().getKey(), this.key.getKey());
            return planIdentifier;
        }
        throw new IllegalStateException("Plan identifier is undefined");
    }

    @NotNull
    public BambooKey getKey() {
        if (this.key == null) {
            throw new IllegalStateException("Plan key is undefined");
        }
        return new BambooKey(this.key.getKey());
    }

    @NotNull
    public BambooOid getOid() {
        if (this.oid == null) {
            throw new IllegalStateException("Plan oid is undefined");
        }
        return new BambooOid(this.oid.getOid());
    }

    @Override
    protected PlanProperties build() throws PropertiesValidationException {
        RepositoryStoredSpecsData repositoryStoredSpecsData = RunnerSettings.getRepositoryStoredSpecsData();
        return new PlanProperties(this.oid, this.key, this.name, this.description, this.project, this.stages, this.repositories, this.triggers, this.variables, this.enabled, this.pluginConfigurations.values(), this.planBranchManagement, this.dependencies, repositoryStoredSpecsData, this.notifications, this.forceStopHungBuilds);
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        if (this.key != null) {
            if (this.project != null && this.project.getKey() != null) {
                return String.format("%s %s-%s", TYPE, this.project.getKey().getKey(), this.key.getKey());
            }
            return String.format("%s %s", TYPE, this.key.getKey());
        }
        return String.format("%s <unknown>", TYPE);
    }
}

