/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.branches;

import com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchManagement;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGeneratorName;
import com.atlassian.bamboo.specs.api.codegen.annotations.DefaultFieldValues;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchCleanupProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.CreatePlanBranchesProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class PlanBranchManagementProperties
implements EntityProperties {
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.branches.CreatePlanBranchesEmitter")
    private CreatePlanBranchesProperties createPlanBranch;
    private BranchCleanupProperties deletePlanBranch;
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.branches.TriggeringOptionEmitter")
    private TriggeringOption triggeringOption;
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.branches.NotificationStrategyEmitter")
    private NotificationStrategy notificationStrategy;
    private BranchIntegrationProperties branchIntegrationProperties;
    private boolean issueLinkingEnabled;

    private PlanBranchManagementProperties() {
    }

    public PlanBranchManagementProperties(CreatePlanBranchesProperties createPlanBranch, BranchCleanupProperties deletePlanBranch, TriggeringOption triggeringOption, NotificationStrategy notificationStrategy, BranchIntegrationProperties branchIntegrationProperties, boolean issueLinkingEnabled) throws PropertiesValidationException {
        this.createPlanBranch = createPlanBranch;
        this.deletePlanBranch = deletePlanBranch;
        this.issueLinkingEnabled = issueLinkingEnabled;
        this.triggeringOption = triggeringOption;
        this.notificationStrategy = notificationStrategy;
        this.branchIntegrationProperties = branchIntegrationProperties;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanBranchManagementProperties that = (PlanBranchManagementProperties)o;
        return this.isIssueLinkingEnabled() == that.isIssueLinkingEnabled() && Objects.equals(this.getCreatePlanBranch(), that.getCreatePlanBranch()) && Objects.equals(this.getDeletePlanBranch(), that.getDeletePlanBranch()) && this.getTriggeringOption() == that.getTriggeringOption() && this.getNotificationStrategy() == that.getNotificationStrategy() && Objects.equals(this.getBranchIntegrationProperties(), that.getBranchIntegrationProperties());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getCreatePlanBranch(), this.getDeletePlanBranch(), this.getTriggeringOption(), this.getNotificationStrategy(), this.getBranchIntegrationProperties(), this.isIssueLinkingEnabled()});
    }

    @Nullable
    public CreatePlanBranchesProperties getCreatePlanBranch() {
        return this.createPlanBranch;
    }

    @Nullable
    public BranchCleanupProperties getDeletePlanBranch() {
        return this.deletePlanBranch;
    }

    public boolean isIssueLinkingEnabled() {
        return this.issueLinkingEnabled;
    }

    @Nullable
    public TriggeringOption getTriggeringOption() {
        return this.triggeringOption;
    }

    @Nullable
    public NotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    @Nullable
    public BranchIntegrationProperties getBranchIntegrationProperties() {
        return this.branchIntegrationProperties;
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Branch monitoring");
        ImporterUtils.checkRequired(context.with("createPlanBranch"), this.createPlanBranch);
        ImporterUtils.checkRequired(context.with("deletePlanBranch"), this.deletePlanBranch);
        ImporterUtils.checkRequired(context.with("triggeringOption"), (Object)this.triggeringOption);
        ImporterUtils.checkRequired(context.with("notificationStrategy"), (Object)this.notificationStrategy);
        ImporterUtils.checkRequired(context.with("branchIntegrationProperties"), this.branchIntegrationProperties);
    }

    @DefaultFieldValues
    private PlanBranchManagementProperties defaults() {
        return (PlanBranchManagementProperties)EntityPropertiesBuilders.build(new PlanBranchManagement());
    }

    public static enum NotificationStrategy {
        NOTIFY_COMMITTERS,
        INHERIT,
        NONE;

    }

    public static enum TriggeringOption {
        INHERITED,
        MANUAL;

    }
}

