/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.trigger;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public abstract class RepositoryBasedTriggerProperties
extends TriggerProperties {
    private final RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType;
    private final List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories;

    protected RepositoryBasedTriggerProperties() {
        this.triggeringRepositoriesType = RepositoryBasedTrigger.TriggeringRepositoriesType.ALL;
        this.selectedTriggeringRepositories = Collections.emptyList();
    }

    public RepositoryBasedTriggerProperties(String name, String description, boolean isEnabled, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories) throws PropertiesValidationException {
        super(name, description, isEnabled);
        this.triggeringRepositoriesType = triggeringRepositoriesType;
        this.selectedTriggeringRepositories = triggeringRepositoriesType == RepositoryBasedTrigger.TriggeringRepositoriesType.SELECTED ? Collections.unmodifiableList(new ArrayList<VcsRepositoryIdentifierProperties>(selectedTriggeringRepositories)) : Collections.emptyList();
    }

    public RepositoryBasedTrigger.TriggeringRepositoriesType getTriggeringRepositoriesType() {
        return this.triggeringRepositoriesType;
    }

    public List<VcsRepositoryIdentifierProperties> getSelectedTriggeringRepositories() {
        return this.selectedTriggeringRepositories;
    }

    @Override
    public void validate() throws PropertiesValidationException {
        super.validate();
    }

    @Override
    public EnumSet<Applicability> applicableTo() {
        return EnumSet.of(Applicability.PLANS);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryBasedTriggerProperties that = (RepositoryBasedTriggerProperties)o;
        return this.triggeringRepositoriesType == that.triggeringRepositoriesType && Objects.equals(this.selectedTriggeringRepositories, that.selectedTriggeringRepositories);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.triggeringRepositoriesType, this.selectedTriggeringRepositories});
    }
}

