/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators;

import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class AtlassianModuleValidator {
    private static final String SEPARATOR = ":";

    private AtlassianModuleValidator() {
    }

    public static List<ValidationProblem> validate(@NotNull AtlassianModuleProperties moduleProperties) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        String key = moduleProperties.getCompleteModuleKey();
        if (StringUtils.contains((CharSequence)key, (CharSequence)SEPARATOR)) {
            String pluginKey = AtlassianModuleValidator.pluginKeyFromCompleteKey(key);
            String moduleKey = AtlassianModuleValidator.moduleKeyFromCompleteKey(key);
            if (StringUtils.isBlank((CharSequence)pluginKey)) {
                errors.add(new ValidationProblem("Plugin key part of complete module key can not be empty."));
            }
            if (StringUtils.isBlank((CharSequence)moduleKey)) {
                errors.add(new ValidationProblem("Module key part of complete module key can not be empty."));
            }
        } else {
            errors.add(new ValidationProblem("Plugin module key must contain ':' separator."));
        }
        return errors;
    }

    private static String pluginKeyFromCompleteKey(String key) {
        if (key != null) {
            return key.split(SEPARATOR)[0];
        }
        return "";
    }

    private static String moduleKeyFromCompleteKey(String key) {
        String[] split;
        if (key != null && (split = key.split(SEPARATOR, 2)).length == 2) {
            return split[1];
        }
        return "";
    }
}

