/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.branches;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchCleanup;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchIntegration;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchCleanupProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.CreatePlanBranchesProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class PlanBranchManagement
extends EntityPropertiesBuilder<PlanBranchManagementProperties> {
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of("Plan Branch Management");
    private CreatePlanBranchesProperties createPlanBranches = new CreatePlanBranchesProperties(CreatePlanBranchesProperties.Trigger.MANUAL, null);
    private BranchCleanupProperties deletePlanBranches = new BranchCleanupProperties(false, Duration.ZERO, false, Duration.ZERO);
    private PlanBranchManagementProperties.TriggeringOption triggeringOption = PlanBranchManagementProperties.TriggeringOption.INHERITED;
    private PlanBranchManagementProperties.NotificationStrategy notificationStrategy = PlanBranchManagementProperties.NotificationStrategy.NONE;
    private BranchIntegrationProperties branchIntegration = new BranchIntegrationProperties(false, null, false, false);
    private TriggerProperties defaultTrigger;
    private boolean issueLinkingEnabled = true;

    public PlanBranchManagement createManually() {
        this.createPlanBranches = new CreatePlanBranchesProperties(CreatePlanBranchesProperties.Trigger.MANUAL, null);
        return this;
    }

    public PlanBranchManagement createForPullRequest() {
        this.createPlanBranches = new CreatePlanBranchesProperties(CreatePlanBranchesProperties.Trigger.PULL_REQUEST, null);
        return this;
    }

    public PlanBranchManagement createForVcsBranch() {
        this.createPlanBranches = new CreatePlanBranchesProperties(CreatePlanBranchesProperties.Trigger.BRANCH, null);
        return this;
    }

    public PlanBranchManagement createForVcsBranchMatching(String pattern) {
        ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "to createForVcsBranchMatching()", pattern);
        this.createPlanBranches = new CreatePlanBranchesProperties(CreatePlanBranchesProperties.Trigger.BRANCH, pattern);
        return this;
    }

    public PlanBranchManagement delete(@NotNull BranchCleanup removedBranchCleanup) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("removedBranchCleanup", removedBranchCleanup);
        this.deletePlanBranches = removedBranchCleanup.build();
        return this;
    }

    public PlanBranchManagement triggerBuildsManually() {
        this.triggeringOption = PlanBranchManagementProperties.TriggeringOption.MANUAL;
        this.defaultTrigger = null;
        return this;
    }

    public PlanBranchManagement triggerBuildsLikeParentPlan() {
        this.triggeringOption = PlanBranchManagementProperties.TriggeringOption.INHERITED;
        this.defaultTrigger = null;
        return this;
    }

    public PlanBranchManagement defaultTrigger(@NotNull Trigger<?, ?> defaultTrigger) {
        this.triggeringOption = PlanBranchManagementProperties.TriggeringOption.CUSTOM;
        this.defaultTrigger = (TriggerProperties)EntityPropertiesBuilders.build(defaultTrigger);
        return this;
    }

    public PlanBranchManagement notificationForCommitters() {
        this.notificationStrategy = PlanBranchManagementProperties.NotificationStrategy.NOTIFY_COMMITTERS;
        return this;
    }

    public PlanBranchManagement notificationLikeParentPlan() {
        this.notificationStrategy = PlanBranchManagementProperties.NotificationStrategy.INHERIT;
        return this;
    }

    public PlanBranchManagement notificationDisabled() {
        this.notificationStrategy = PlanBranchManagementProperties.NotificationStrategy.NONE;
        return this;
    }

    public PlanBranchManagement branchIntegration(@NotNull BranchIntegration branchIntegration) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("branchIntegration", branchIntegration);
        this.branchIntegration = branchIntegration.build();
        return this;
    }

    public PlanBranchManagement issueLinkingEnabled(boolean issueLinkingEnabled) throws PropertiesValidationException {
        this.issueLinkingEnabled = issueLinkingEnabled;
        return this;
    }

    @Override
    protected PlanBranchManagementProperties build() throws PropertiesValidationException {
        return new PlanBranchManagementProperties(this.createPlanBranches, this.deletePlanBranches, this.triggeringOption, this.defaultTrigger, this.notificationStrategy, this.branchIntegration, this.issueLinkingEnabled);
    }
}

