/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.branches;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchIntegration;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class PlanBranchConfiguration
extends EntityPropertiesBuilder<PlanBranchConfigurationProperties> {
    private boolean cleanupEnabled = true;
    private BranchIntegrationProperties branchIntegration = new BranchIntegrationProperties(false, null, false, false);

    @NotNull
    public PlanBranchConfiguration cleanupEnabled(boolean cleanupEnabled) {
        this.cleanupEnabled = cleanupEnabled;
        return this;
    }

    @NotNull
    public PlanBranchConfiguration disableAutomaticCleanup() {
        this.cleanupEnabled = false;
        return this;
    }

    @NotNull
    public PlanBranchConfiguration enableAutomaticCleanup() {
        this.cleanupEnabled = false;
        return this;
    }

    public PlanBranchConfiguration branchIntegration(@NotNull BranchIntegration branchIntegration) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("branchIntegration", branchIntegration);
        this.branchIntegration = branchIntegration.build();
        return this;
    }

    @Override
    protected PlanBranchConfigurationProperties build() {
        return new PlanBranchConfigurationProperties(this.branchIntegration, this.cleanupEnabled);
    }
}

