/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.context;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class RssRuntimeContext {
    private static final String RSS_CURRENT_BRANCH_PROPERTY_NAME = "rss.current.branch";
    private static final String RSS_IS_DEFAULT_BRANCH_PROPERTY_NAME = "rss.default.branch";
    private static String currentBranch;
    private static Boolean isDefaultBranch;

    @NotNull
    public static Optional<String> getCurrentRssBranch() {
        return Optional.ofNullable(currentBranch);
    }

    @NotNull
    public static Optional<Boolean> isDefaultRssBranch() {
        return Optional.ofNullable(isDefaultBranch);
    }

    private static void loadProperties() {
        String property = System.getProperty(RSS_CURRENT_BRANCH_PROPERTY_NAME);
        if (property != null) {
            try {
                currentBranch = new String(Base64.getDecoder().decode(property.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                currentBranch = property;
            }
        }
        if ((property = System.getProperty(RSS_IS_DEFAULT_BRANCH_PROPERTY_NAME)) != null) {
            isDefaultBranch = Boolean.valueOf(property);
        }
    }

    private RssRuntimeContext() {
    }

    static {
        RssRuntimeContext.loadProperties();
    }
}

