/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.credentials;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"name"})
@Immutable
public final class SharedCredentialsIdentifierProperties
implements EntityProperties {
    private final BambooOidProperties oid;
    private final String name;

    private SharedCredentialsIdentifierProperties() {
        this.name = null;
        this.oid = null;
    }

    public SharedCredentialsIdentifierProperties(@Nullable String name, @Nullable BambooOidProperties oid) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
        this.validate();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isNameDefined() {
        return StringUtils.isNotBlank((CharSequence)this.name);
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public boolean isOidDefined() {
        return this.oid != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedCredentialsIdentifierProperties that = (SharedCredentialsIdentifierProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getOid(), this.getName());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("oid", (Object)this.oid).append("name", (Object)this.name).build();
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.name) && this.oid == null) {
            throw new PropertiesValidationException("Either name or oid need to be defined when referencing shared credentials");
        }
    }
}

