/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.artifact;

import com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public final class ArtifactProperties
implements EntityProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of("Artifact");
    private final String name;
    private final String copyPattern;
    private final String location;
    private final boolean shared;
    private final boolean required;

    private ArtifactProperties() {
        this.shared = Artifact.SHARED_BY_DEFAULT;
        this.required = Artifact.REQUIRED_BY_DEFAULT;
        this.name = null;
        this.location = "";
        this.copyPattern = null;
    }

    public ArtifactProperties(String name, String copyPattern, String location, boolean shared, boolean required) throws PropertiesValidationException {
        this.name = name;
        this.copyPattern = copyPattern;
        this.location = location;
        this.shared = shared;
        this.required = required;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactProperties that = (ArtifactProperties)o;
        return this.isShared() == that.isShared() && this.isRequired() == that.isRequired() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getCopyPattern(), that.getCopyPattern()) && Objects.equals(this.getLocation(), that.getLocation());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getCopyPattern(), this.getLocation(), this.isShared(), this.isRequired());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("name", (Object)this.name).append("copyPattern", (Object)this.copyPattern).append("location", (Object)this.location).append("shared", this.shared).append("required", this.required).build();
    }

    public String getName() {
        return this.name;
    }

    public String getCopyPattern() {
        return this.copyPattern;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void validate() {
        ImporterUtils.checkArgument(VALIDATION_CONTEXT, !StringUtils.contains((CharSequence)this.name, (CharSequence)"/"), "Name can not contain '/' character");
    }
}

