package com.atlassian.bamboo.specs.api.builders;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

/**
 * Represents an unique identifier of Bamboo entity (project, plan, repository, job, etc.)
 * Those identifiers are generated by Bamboo and thus are not available when creating new objects, therefore
 * secondary identifiers, i.e. {@link BambooKey} and names can be used as well.
 * It is recommended however, to use these identifiers when updating existing Bamboo data or transfering data
 * between Bamboo servers as they provide stronger guarantees nb. uniqueness.
 * <p>
 * If both oid and a secondary identifier is present, oid has higher priority. In particular, when both oid and name is present
 * it is possible to rename an existing object.
 *
 * @see BambooKey
 */
public class BambooOid extends EntityPropertiesBuilder<BambooOidProperties> {
    private String oid;

    /**
     * Specify an entity oid from its string value.
     *
     * @param oid oid in string format (long number in {@link Character#MAX_RADIX} radix)
     */
    public BambooOid(@NotNull String oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = oid;
    }

    protected BambooOidProperties build() throws PropertiesValidationException {
        return new BambooOidProperties(oid);
    }
}
