/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.plan.StageValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"name"})
@Immutable
public final class StageProperties
implements EntityProperties {
    private final String name;
    private final String description;
    @Setter(value="manual")
    private final boolean manualStage;
    private final boolean finalStage;
    private List<JobProperties> jobs;

    private StageProperties() {
        this.name = null;
        this.description = "";
        this.manualStage = false;
        this.finalStage = false;
        this.jobs = Collections.emptyList();
    }

    public StageProperties(String name, String description, boolean manualStage, boolean finalStage, List<JobProperties> jobs) throws PropertiesValidationException {
        this.name = name;
        this.description = description;
        this.manualStage = manualStage;
        this.finalStage = finalStage;
        this.jobs = Collections.unmodifiableList(new ArrayList<JobProperties>(jobs));
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageProperties that = (StageProperties)o;
        return this.isManual() == that.isManual() && this.isFinalStage() == that.isFinalStage() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getJobs(), that.getJobs());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getDescription(), this.isManual(), this.isFinalStage(), this.getJobs());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isManual() {
        return this.manualStage;
    }

    public boolean isFinalStage() {
        return this.finalStage;
    }

    @NotNull
    public List<JobProperties> getJobs() {
        return this.jobs;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("name", this.name);
        ImporterUtils.checkNotNull("jobs", this.jobs);
        ImporterUtils.checkNoErrors(StageValidator.validate(this));
    }
}

