/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.trigger;

import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnyTriggerConditionProperties
extends TriggerConditionProperties {
    private final AtlassianModuleProperties atlassianPlugin;
    private final Map<String, String> config = new LinkedHashMap<String, String>();

    private AnyTriggerConditionProperties() {
        this.atlassianPlugin = null;
    }

    public AnyTriggerConditionProperties(@Nullable AtlassianModuleProperties atlassianPlugin, @NotNull Map<String, String> config) {
        this.atlassianPlugin = atlassianPlugin;
        this.config.putAll(config);
        this.validate();
    }

    @Override
    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return this.atlassianPlugin;
    }

    @NotNull
    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkNotNull("config", this.config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyTriggerConditionProperties that = (AnyTriggerConditionProperties)o;
        return Objects.equals(this.atlassianPlugin, that.atlassianPlugin) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.atlassianPlugin, this.config);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("atlassianPlugin", (Object)this.atlassianPlugin).append("config", this.config).toString();
    }
}

