/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.Job;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stage
extends EntityPropertiesBuilder<StageProperties> {
    private String name;
    private String description = "";
    private boolean manualStage;
    private boolean finalStage;
    private List<JobProperties> jobs = new ArrayList<JobProperties>();

    public Stage(@NotNull Stage copy) {
        this.name = copy.name;
        this.description = copy.description;
        this.manualStage = copy.manualStage;
        this.finalStage = copy.finalStage;
        this.jobs.addAll(copy.jobs);
    }

    public Stage(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        this.name = name;
    }

    public Stage name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        this.name = name;
        return this;
    }

    public Stage description(@Nullable String description) throws PropertiesValidationException {
        this.description = description;
        return this;
    }

    public Stage manual(boolean isManual) throws PropertiesValidationException {
        this.manualStage = isManual;
        return this;
    }

    public Stage finalStage(boolean isFinal) throws PropertiesValidationException {
        this.finalStage = isFinal;
        return this;
    }

    public Stage jobs(Job ... jobs) {
        ImporterUtils.checkNotNull("jobs", jobs);
        Arrays.stream(jobs).map(EntityPropertiesBuilders::build).forEach(this.jobs::add);
        return this;
    }

    @Override
    protected StageProperties build() throws PropertiesValidationException {
        return new StageProperties(this.name, this.description, this.manualStage, this.finalStage, this.jobs);
    }
}

