/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.permission;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public final class PlanPermissions
extends RootEntityPropertiesBuilder<PlanPermissionsProperties> {
    public static final String TYPE = "plan permission";
    @NotNull
    private final PlanIdentifier planIdentifier;
    private Permissions permissions = new Permissions();

    public PlanPermissions(BambooOid planOid) {
        this(new PlanIdentifier(planOid));
    }

    public PlanPermissions(BambooKey projectKey, BambooKey planKey) {
        this(new PlanIdentifier(projectKey, planKey));
    }

    public PlanPermissions(PlanIdentifier planIdentifier) {
        this.planIdentifier = planIdentifier;
    }

    public PlanPermissions permissions(@NotNull Permissions permissions) {
        ImporterUtils.checkNotNull("permissions", permissions);
        this.permissions = permissions;
        return this;
    }

    public PlanPermissions addDefaultPermissions() {
        this.permissions.loggedInUserPermissions(PermissionType.VIEW);
        this.permissions.anonymousUserPermissionView();
        return this;
    }

    @NotNull
    public PlanIdentifier getPlanIdentifier() {
        return this.planIdentifier;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    protected PlanPermissionsProperties build() {
        return new PlanPermissionsProperties(this.planIdentifier, this.permissions);
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        return String.format("%s for plan %s", TYPE, this.planIdentifier);
    }
}

