/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.branches;

import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanBranchConfigurationProperties
implements EntityProperties {
    private boolean cleanupEnabled;
    private BranchIntegrationProperties branchIntegrationProperties;

    private PlanBranchConfigurationProperties() {
        this.cleanupEnabled = true;
    }

    public PlanBranchConfigurationProperties(@NotNull BranchIntegrationProperties branchIntegration, boolean cleanupEnabled) {
        this.branchIntegrationProperties = branchIntegration;
        this.cleanupEnabled = cleanupEnabled;
        this.validate();
    }

    public boolean isCleanupEnabled() {
        return this.cleanupEnabled;
    }

    @Nullable
    public BranchIntegrationProperties getBranchIntegrationProperties() {
        return this.branchIntegrationProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanBranchConfigurationProperties that = (PlanBranchConfigurationProperties)o;
        return this.isCleanupEnabled() == that.isCleanupEnabled() && Objects.equals(this.getBranchIntegrationProperties(), that.getBranchIntegrationProperties());
    }

    public int hashCode() {
        return Objects.hash(this.isCleanupEnabled(), this.getBranchIntegrationProperties());
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Branch configuration");
        ImporterUtils.checkRequired(context.with("branchIntegrationProperties"), this.branchIntegrationProperties);
    }
}

