/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.project;

import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.project.ProjectValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Builder(value=Project.class)
@Immutable
public final class ProjectProperties
implements RootEntityProperties {
    private BambooOidProperties oid;
    private BambooKeyProperties key;
    private String name;
    private String description;
    private final List<VariableProperties> variables;
    private final List<SharedCredentialsProperties> sharedCredentials;
    private final List<VcsRepositoryProperties> repositories;
    @SkipCodeGen
    @Nullable
    private final RepositoryStoredSpecsData repositoryStoredSpecsData;

    private ProjectProperties() {
        this.variables = Collections.emptyList();
        this.sharedCredentials = Collections.emptyList();
        this.repositories = Collections.emptyList();
        this.repositoryStoredSpecsData = null;
    }

    public ProjectProperties(BambooOidProperties oid, BambooKeyProperties key, String name, String description, @NotNull List<VariableProperties> variables, @NotNull List<SharedCredentialsProperties> sharedCredentials, @NotNull List<VcsRepositoryProperties> repositories, @Nullable RepositoryStoredSpecsData repositoryStoredSpecsData) throws PropertiesValidationException {
        this.oid = oid;
        this.key = key;
        this.name = name;
        this.description = description;
        this.variables = Collections.unmodifiableList(new ArrayList<VariableProperties>(variables));
        this.sharedCredentials = Collections.unmodifiableList(new ArrayList<SharedCredentialsProperties>(sharedCredentials));
        this.repositories = Collections.unmodifiableList(new ArrayList<VcsRepositoryProperties>(repositories));
        this.repositoryStoredSpecsData = repositoryStoredSpecsData;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectProperties that = (ProjectProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getVariables(), that.getVariables()) && Objects.equals(this.getSharedCredentials(), that.getSharedCredentials()) && Objects.equals(this.getRepositories(), that.getRepositories()) && Objects.equals(this.getRepositoryStoredSpecsData(), that.getRepositoryStoredSpecsData());
    }

    public int hashCode() {
        return Objects.hash(this.getOid(), this.getKey(), this.getName(), this.getDescription(), this.getRepositoryStoredSpecsData());
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    @Nullable
    public BambooKeyProperties getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<VariableProperties> getVariables() {
        return this.variables != null ? this.variables : Collections.emptyList();
    }

    @NotNull
    public List<SharedCredentialsProperties> getSharedCredentials() {
        return this.sharedCredentials != null ? this.sharedCredentials : Collections.emptyList();
    }

    @NotNull
    public List<VcsRepositoryProperties> getRepositories() {
        return this.repositories != null ? this.repositories : Collections.emptyList();
    }

    @Nullable
    public RepositoryStoredSpecsData getRepositoryStoredSpecsData() {
        return this.repositoryStoredSpecsData;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNoErrors(ProjectValidator.validate(this));
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "project";
    }

    @Override
    @NotNull
    public String humanReadableId() {
        if (this.key != null) {
            return String.format("%s %s", "project", this.key.getKey());
        }
        return String.format("%s <unknown>", "project");
    }
}

