/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.project;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.rsbs.RunnerSettings;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Project
extends RootEntityPropertiesBuilder<ProjectProperties> {
    public static final String TYPE = "project";
    private BambooKeyProperties key;
    private BambooOidProperties oid;
    private String name;
    private String description;
    private List<VariableProperties> variables = new ArrayList<VariableProperties>();
    private List<SharedCredentialsProperties> sharedCredentials = new ArrayList<SharedCredentialsProperties>();
    private List<VcsRepositoryProperties> repositories = new ArrayList<VcsRepositoryProperties>();

    public Project name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("name", name);
        this.name = name;
        return this;
    }

    public Project key(@Nullable String key) throws PropertiesValidationException {
        return this.key(key != null ? new BambooKey(key) : null);
    }

    public Project key(@Nullable BambooKey key) throws PropertiesValidationException {
        this.key = key != null ? (BambooKeyProperties)EntityPropertiesBuilders.build(key) : null;
        return this;
    }

    public Project description(@Nullable String description) throws PropertiesValidationException {
        this.description = description;
        return this;
    }

    public Project oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public Project oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return this;
    }

    public Project variables(Variable ... variables) {
        ImporterUtils.checkNotNull("variables", variables);
        Arrays.stream(variables).map(EntityPropertiesBuilders::build).forEach(this.variables::add);
        return this;
    }

    public Project sharedCredentials(SharedCredentials<?, ?> ... credentials) {
        ImporterUtils.checkNotNull("shared credentials", credentials);
        Arrays.stream(credentials).map(c -> c.project(this)).map(EntityPropertiesBuilders::build).forEach(this.sharedCredentials::add);
        return this;
    }

    public Project repositories(VcsRepository<?, ?> ... repositories) {
        ImporterUtils.checkNotNull("repositories", repositories);
        Arrays.stream(repositories).map(r -> r.project(this)).map(EntityPropertiesBuilders::build).forEach(this.repositories::add);
        return this;
    }

    public BambooOid getOid() {
        if (this.oid == null) {
            throw new IllegalStateException("Project oid is undefined");
        }
        return new BambooOid(this.oid.getOid());
    }

    public BambooKey getKey() {
        if (this.key == null) {
            throw new IllegalStateException("Project key is undefined");
        }
        return new BambooKey(this.key.getKey());
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected ProjectProperties build() throws PropertiesValidationException {
        RepositoryStoredSpecsData repositoryStoredSpecsData = RunnerSettings.getRepositoryStoredSpecsData();
        return new ProjectProperties(this.oid, this.key, this.name, this.description, this.variables, this.sharedCredentials, this.repositories, repositoryStoredSpecsData);
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        if (this.key != null) {
            return String.format("%s %s", TYPE, this.key.getKey());
        }
        return String.format("%s <unknown>", TYPE);
    }
}

