/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.deployment;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.deployment.Environment;
import com.atlassian.bamboo.specs.api.builders.deployment.ReleaseNaming;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.ReleaseNamingProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.rsbs.RunnerSettings;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Deployment
extends RootEntityPropertiesBuilder<DeploymentProperties> {
    public static final String TYPE = "deployment";
    private BambooOidProperties oid;
    private PlanIdentifierProperties plan;
    private String name;
    private String description;
    private ReleaseNamingProperties releaseNaming;
    private List<EnvironmentProperties> environments = new ArrayList<EnvironmentProperties>();

    public Deployment(@NotNull PlanIdentifier plan, @NotNull String name) {
        ImporterUtils.checkNotNull("plan", plan);
        ImporterUtils.checkNotBlank("name", name);
        this.plan = (PlanIdentifierProperties)EntityPropertiesBuilders.build(plan);
        this.name = name;
    }

    public Deployment name(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
        return this;
    }

    public Deployment oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public Deployment oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return this;
    }

    public Deployment description(String description) {
        this.description = description;
        return this;
    }

    public Deployment releaseNaming(@NotNull ReleaseNaming releaseNaming) {
        ImporterUtils.checkNotNull("releaseNaming", releaseNaming);
        this.releaseNaming = (ReleaseNamingProperties)EntityPropertiesBuilders.build(releaseNaming);
        return this;
    }

    public Deployment environments(Environment ... environments) {
        ImporterUtils.checkNotNull("environments", environments);
        Arrays.stream(environments).map(EntityPropertiesBuilders::build).forEach(this.environments::add);
        return this;
    }

    @Override
    protected DeploymentProperties build() {
        RepositoryStoredSpecsData repositoryStoredSpecsData = RunnerSettings.getRepositoryStoredSpecsData();
        return new DeploymentProperties(this.oid, this.plan, this.name, this.description, this.releaseNaming, this.environments, repositoryStoredSpecsData);
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        return String.format("%s %s", TYPE, StringUtils.defaultString((String)this.name, (String)"<unknown>"));
    }

    public BambooOidProperties getOid() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }
}

