/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.deployment;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.docker.DockerConfiguration;
import com.atlassian.bamboo.specs.api.builders.notification.Notification;
import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.EnvironmentPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Environment
extends EntityPropertiesBuilder<EnvironmentProperties> {
    private String name;
    private String description;
    private List<TaskProperties> tasks = new ArrayList<TaskProperties>();
    private List<TaskProperties> finalTasks = new ArrayList<TaskProperties>();
    private List<TriggerProperties> triggers = new ArrayList<TriggerProperties>();
    private List<VariableProperties> variables = new ArrayList<VariableProperties>();
    private List<RequirementProperties> requirements = new ArrayList<RequirementProperties>();
    private List<NotificationProperties> notifications = new ArrayList<NotificationProperties>();
    private DockerConfigurationProperties dockerConfiguration;
    private Map<String, EnvironmentPluginConfigurationProperties> pluginConfigurations = new LinkedHashMap<String, EnvironmentPluginConfigurationProperties>();

    public Environment(@NotNull String name) {
        ImporterUtils.checkNotNull("name", name);
        this.name = name;
        this.dockerConfiguration(new DockerConfiguration().enabled(false));
    }

    public Environment description(String description) {
        this.description = description;
        return this;
    }

    public Environment tasks(Task<?, ?> ... tasks) {
        ImporterUtils.checkNotNull("tasks", tasks);
        for (Task<?, ?> t : tasks) {
            TaskProperties task = (TaskProperties)EntityPropertiesBuilders.build(t);
            if (!task.applicableTo().contains((Object)Applicability.DEPLOYMENTS)) {
                throw new PropertiesValidationException("Task " + t.getClass().getSimpleName() + " is not available in deployments");
            }
            this.addTask(this.tasks, task);
        }
        return this;
    }

    public Environment finalTasks(Task<?, ?> ... finalTasks) {
        ImporterUtils.checkNotNull("finalTasks", finalTasks);
        for (Task<?, ?> t : finalTasks) {
            TaskProperties task = (TaskProperties)EntityPropertiesBuilders.build(t);
            if (!task.applicableTo().contains((Object)Applicability.DEPLOYMENTS)) {
                throw new PropertiesValidationException("Task " + t.getClass().getSimpleName() + " is not available in deployments");
            }
            this.addTask(this.finalTasks, task);
        }
        return this;
    }

    private void addTask(List<TaskProperties> tasks, TaskProperties task) {
        this.requirements.addAll(task.getRequirements());
        tasks.add(task);
    }

    public Environment triggers(Trigger<?, ?> ... triggers) {
        ImporterUtils.checkNotNull("triggers", triggers);
        for (Trigger<?, ?> t : triggers) {
            TriggerProperties trigger = (TriggerProperties)EntityPropertiesBuilders.build(t);
            if (!trigger.applicableTo().contains((Object)Applicability.DEPLOYMENTS)) {
                throw new PropertiesValidationException("Trigger " + t.getClass().getSimpleName() + " is not available in deployments");
            }
            this.triggers.add(trigger);
        }
        return this;
    }

    public Environment variables(Variable ... variables) {
        ImporterUtils.checkNotNull("variables", variables);
        Arrays.stream(variables).map(EntityPropertiesBuilders::build).forEach(this.variables::add);
        return this;
    }

    public Environment requirements(Requirement ... requirements) {
        ImporterUtils.checkNotNull("requirements", requirements);
        Arrays.stream(requirements).map(EntityPropertiesBuilders::build).forEach(this.requirements::add);
        return this;
    }

    public Environment notifications(Notification ... notifications) {
        ImporterUtils.checkNotNull("notifications", notifications);
        Arrays.stream(notifications).map(EntityPropertiesBuilders::build).forEach(notification -> {
            ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
            if (!notification.getType().applicableTo().contains((Object)Applicability.DEPLOYMENTS)) {
                problems.add(new ValidationProblem(String.format("Can't add notification because notification type (%s) is not available in deployments", notification.getType().getAtlassianPlugin().getCompleteModuleKey())));
            }
            for (NotificationRecipientProperties recipient : notification.getRecipients()) {
                if (recipient.applicableTo().contains((Object)Applicability.DEPLOYMENTS)) continue;
                problems.add(new ValidationProblem(String.format("Can't add notification because notification recipient (%s) is not available in deployments", recipient.getAtlassianPlugin().getCompleteModuleKey())));
            }
            if (!problems.isEmpty()) {
                throw new PropertiesValidationException(problems);
            }
            this.notifications.add((NotificationProperties)notification);
        });
        return this;
    }

    public Environment dockerConfiguration(@NotNull DockerConfiguration dockerConfiguration) {
        ImporterUtils.checkNotNull("dockerConfiguration", dockerConfiguration);
        this.dockerConfiguration = (DockerConfigurationProperties)EntityPropertiesBuilders.build(dockerConfiguration);
        return this;
    }

    public Environment pluginConfigurations(EnvironmentPluginConfiguration<? extends EnvironmentPluginConfigurationProperties> ... pluginConfigurations) {
        ImporterUtils.checkNotNull("pluginConfigurations", pluginConfigurations);
        for (EnvironmentPluginConfiguration<? extends EnvironmentPluginConfigurationProperties> pluginConfiguration : pluginConfigurations) {
            if (pluginConfiguration == null) continue;
            this.putPluginConfiguration(pluginConfiguration);
        }
        return this;
    }

    private void putPluginConfiguration(EnvironmentPluginConfiguration<?> pluginConfiguration) {
        EnvironmentPluginConfigurationProperties pluginConfigurationProperties = (EnvironmentPluginConfigurationProperties)EntityPropertiesBuilders.build(pluginConfiguration);
        this.pluginConfigurations.put(pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey(), pluginConfigurationProperties);
    }

    @Override
    protected EnvironmentProperties build() {
        return new EnvironmentProperties(this.name, this.description, this.tasks, this.finalTasks, this.triggers, this.variables, this.requirements, this.notifications, this.dockerConfiguration, this.pluginConfigurations.values());
    }
}

