/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.permission;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.permission.EnvironmentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class EnvironmentPermissions
extends RootEntityPropertiesBuilder<EnvironmentPermissionsProperties> {
    public static final String TYPE = "environment permission";
    private BambooOid deploymentOid;
    private String deploymentName;
    private String environmentName;
    private Permissions permissions;

    @Override
    protected EnvironmentPermissionsProperties build() {
        PermissionsProperties permissionProperties;
        PermissionsProperties permissionsProperties = permissionProperties = this.permissions != null ? (PermissionsProperties)EntityPropertiesBuilders.build(this.permissions) : null;
        if (this.deploymentOid != null) {
            return new EnvironmentPermissionsProperties((BambooOidProperties)EntityPropertiesBuilders.build(this.deploymentOid), this.environmentName, permissionProperties);
        }
        return new EnvironmentPermissionsProperties(this.deploymentName, this.environmentName, permissionProperties);
    }

    public EnvironmentPermissions(BambooOid deploymentOid) {
        ImporterUtils.checkNotNull("deploymentOid", deploymentOid);
        this.deploymentOid = deploymentOid;
    }

    public EnvironmentPermissions(String deploymentProjectName) {
        ImporterUtils.checkNotBlank("deployment project name", deploymentProjectName);
        this.deploymentName = deploymentProjectName;
    }

    public EnvironmentPermissions(String deploymentProjectName, String environmentName) {
        ImporterUtils.checkNotBlank("deployment project name", deploymentProjectName);
        ImporterUtils.checkNotBlank("environment name", environmentName);
        this.deploymentName = deploymentProjectName;
        this.environmentName = environmentName;
    }

    public EnvironmentPermissions deploymentProjectName(String deploymentProjectName) {
        ImporterUtils.checkNotBlank("deployment project name", deploymentProjectName);
        this.deploymentName = deploymentProjectName;
        return this;
    }

    public EnvironmentPermissions environmentName(@NotNull String environmentName) {
        ImporterUtils.checkNotBlank("environment name", environmentName);
        this.environmentName = environmentName;
        return this;
    }

    public EnvironmentPermissions permissions(Permissions permissions) {
        ImporterUtils.checkNotNull("permissions", permissions);
        this.permissions = permissions;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        StringBuilder id = new StringBuilder();
        id.append(TYPE);
        id.append(" for deployment ");
        if (this.deploymentOid != null) {
            id.append(this.deploymentOid);
        } else {
            id.append(this.deploymentName);
        }
        id.append(" environment ");
        id.append(this.environmentName);
        return id.toString();
    }
}

