/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.plan.AbstractPlanValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public abstract class AbstractPlanProperties
implements EntityProperties {
    private BambooKeyProperties key;
    private BambooOidProperties oid;
    private String name;
    private String description;
    private boolean enabled;
    private List<PluginConfigurationProperties> pluginConfigurations;

    AbstractPlanProperties() {
        this.enabled = true;
        this.description = "";
        this.pluginConfigurations = Collections.emptyList();
    }

    public AbstractPlanProperties(BambooOidProperties oid, BambooKeyProperties key, String name, String description, boolean enabled, Collection<PluginConfigurationProperties> pluginConfigurations) throws PropertiesValidationException {
        this.key = key;
        this.oid = oid;
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.pluginConfigurations = Collections.unmodifiableList(new ArrayList<PluginConfigurationProperties>(pluginConfigurations));
    }

    @NotNull
    private BambooKeyProperties toPlanIdentifierUnsafe() throws PropertiesValidationException {
        BambooKey jobIdentifier = new BambooKey(this.key.getKey());
        return (BambooKeyProperties)EntityPropertiesBuilders.build(jobIdentifier);
    }

    @NotNull
    public BambooKeyProperties toPlanIdentifier() {
        try {
            return this.toPlanIdentifierUnsafe();
        }
        catch (PropertiesValidationException e) {
            String errors = e.getErrors().stream().map(ValidationProblem::getMessage).collect(Collectors.joining(", "));
            throw new IllegalStateException(errors);
        }
    }

    @Nullable
    public BambooKeyProperties getKey() {
        return this.key;
    }

    public boolean isKeyDefined() {
        return this.key != null;
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public boolean isOidDefined() {
        return this.oid != null;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public List<PluginConfigurationProperties> getPluginConfigurations() {
        return this.pluginConfigurations;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNoErrors(AbstractPlanValidator.validate(this));
        this.toPlanIdentifierUnsafe();
    }
}

