/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.trigger;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TriggerProperties
implements EntityProperties {
    private final String name;
    private final String description;
    private final boolean enabled;
    private final List<? extends TriggerConditionProperties> conditions;

    protected TriggerProperties() {
        this.name = null;
        this.description = null;
        this.enabled = true;
        this.conditions = Collections.emptyList();
    }

    public TriggerProperties(@NotNull String name, String description, boolean enabled, Set<TriggerConditionProperties> conditions) {
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.conditions = Collections.unmodifiableList(new ArrayList<TriggerConditionProperties>(conditions));
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public List<? extends TriggerConditionProperties> getConditions() {
        return this.conditions;
    }

    @NotNull
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerProperties that = (TriggerProperties)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.enabled, this.conditions);
    }

    @Override
    public void validate() throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", this.name);
    }

    public EnumSet<Applicability> applicableTo() {
        return EnumSet.allOf(Applicability.class);
    }

    public String toString() {
        return "TriggerProperties{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", conditions=" + this.conditions + ", enabled=" + this.enabled + '}';
    }
}

