/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.artifact;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Artifact
extends EntityPropertiesBuilder<ArtifactProperties> {
    public static final boolean SHARED_BY_DEFAULT = InliningUtils.preventInlining(false);
    public static final boolean REQUIRED_BY_DEFAULT = InliningUtils.preventInlining(false);
    public static final boolean HTTP_COMPRESSION_ON_BY_DEFAULT = InliningUtils.preventInlining(true);
    private String name;
    private final List<String> copyPatterns = new ArrayList<String>();
    private final List<String> exclusionPatterns = new ArrayList<String>();
    private String location = "";
    private boolean shared = SHARED_BY_DEFAULT;
    private boolean required = REQUIRED_BY_DEFAULT;
    private boolean httpCompressionOn = HTTP_COMPRESSION_ON_BY_DEFAULT;

    public Artifact() {
    }

    public Artifact(@NotNull String name) throws PropertiesValidationException {
        this.validateName(name);
        this.name = name;
    }

    public Artifact name(@NotNull String name) throws PropertiesValidationException {
        this.validateName(name);
        this.name = name;
        return this;
    }

    @Deprecated
    public Artifact copyPattern(@NotNull String copyPattern) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("copyPattern", copyPattern);
        this.copyPatterns.clear();
        this.copyPatterns.add(copyPattern);
        return this;
    }

    public Artifact copyPatterns(String ... copyPatterns) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("copyPatterns", copyPatterns);
        for (String copyPattern : copyPatterns) {
            ImporterUtils.checkNotNull("copyPattern", copyPattern);
            this.copyPatterns.add(copyPattern);
        }
        return this;
    }

    public Artifact exclusionPatterns(String ... exclusionPatterns) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("exclusionPatterns", exclusionPatterns);
        for (String exclusionPattern : exclusionPatterns) {
            ImporterUtils.checkNotNull("exclusionPattern", exclusionPattern);
            this.exclusionPatterns.add(exclusionPattern);
        }
        return this;
    }

    public Artifact shared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public Artifact required() {
        this.required = true;
        return this;
    }

    public Artifact required(boolean mandatory) {
        this.required = mandatory;
        return this;
    }

    public Artifact httpCompressionOn(boolean httpCompressionOn) {
        this.httpCompressionOn = httpCompressionOn;
        return this;
    }

    public Artifact location(@NotNull String location) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("location", location);
        this.location = location;
        return this;
    }

    @NotNull
    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalStateException("Artifact name is undefined");
        }
        return this.name;
    }

    @Override
    protected ArtifactProperties build() throws PropertiesValidationException {
        return new ArtifactProperties(this.name, this.copyPatterns, this.exclusionPatterns, this.location, this.shared, this.required, this.httpCompressionOn);
    }

    private void validateName(String name) {
        ImporterUtils.checkNotNull("name", name);
        ImporterUtils.checkArgument(ArtifactProperties.VALIDATION_CONTEXT, !StringUtils.contains((CharSequence)name, (CharSequence)"/"), "Name can not contain '/' character");
    }
}

