/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.project;

import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ProjectValidator {
    private ProjectValidator() {
    }

    @NotNull
    public static List<ValidationProblem> validate(@NotNull ProjectProperties projectProperties) {
        ValidationContext context = ValidationContext.of("Project");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (projectProperties.getKey() == null && projectProperties.getOid() == null) {
            errors.add(new ValidationProblem("Either key or oid need to be defined for project"));
        }
        errors.addAll(ValidationUtils.validateName(context, projectProperties.getName(), false));
        errors.addAll(ValidationUtils.validateDescription(context, projectProperties.getDescription()));
        return errors;
    }
}

