/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import org.apache.maven.plugin.logging.Log;

public class FileToBambooSpecsMapper
implements Function<Path, Optional<Class<?>>> {
    private final Log log;
    private final ClassLoader classLoader;
    private final Class<? extends Annotation> planAnnotation;

    public FileToBambooSpecsMapper(Log log, ClassLoader classLoader) {
        this.log = log;
        this.classLoader = classLoader;
        try {
            this.planAnnotation = this.classLoader.loadClass("com.atlassian.bamboo.specs.api.BambooSpec");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find Bamboo plan marker", e);
        }
    }

    @Override
    public Optional<Class<?>> apply(Path path) {
        try {
            String className = path.toString().replace("/", ".").replace("\\", ".").replace(".class", "");
            this.log.debug((CharSequence)("Scanning " + className + " for " + this.planAnnotation.getSimpleName() + " annotation."));
            Class<?> someClass = this.classLoader.loadClass(className);
            if (someClass.getAnnotation(this.planAnnotation) == null) {
                this.log.debug((CharSequence)(this.planAnnotation.getSimpleName() + " annotation not found on " + String.valueOf(someClass)));
                return Optional.empty();
            }
            this.log.info((CharSequence)("Found @" + this.planAnnotation.getSimpleName() + " annotation on " + String.valueOf(someClass)));
            return Optional.of(someClass);
        }
        catch (ClassNotFoundException e) {
            this.log.warn((CharSequence)("Error when loading class " + String.valueOf(path)), (Throwable)e);
            return Optional.empty();
        }
    }
}

