/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StackTraceUtils {
    private static final Map<String, File> CODESOURCES = new HashMap<String, File>();

    private StackTraceUtils() {
    }

    @Nullable
    static StackTraceElement[] getCallerStack(Class<?> ... beforeClasses) {
        return StackTraceUtils.getCallerStack(0, beforeClasses);
    }

    @Nullable
    static StackTraceElement[] getCallerStack(int skipTopN, Class<?> ... beforeClasses) {
        Set classNames = Arrays.stream(beforeClasses).map(Class::getName).collect(Collectors.toSet());
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int classFound = -1;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (classNames.contains(stackTrace[i].getClassName())) {
                classFound = i;
                continue;
            }
            if (classFound >= skipTopN) break;
        }
        return classFound >= skipTopN ? Arrays.copyOfRange(stackTrace, classFound + 1, stackTrace.length - 1) : null;
    }

    @NotNull
    static Set<File> getClassLocationsOnStack(ClassLoader classLoader, StackTraceElement[] callerStackTrace) {
        HashSet<File> jars = new HashSet<File>();
        for (StackTraceElement stackTraceElement : callerStackTrace) {
            jars.add(StackTraceUtils.classNameToJar(classLoader, stackTraceElement.getClassName()));
        }
        return jars;
    }

    private static File classNameToJar(ClassLoader classLoader, String className) {
        return CODESOURCES.computeIfAbsent(className, StackTraceUtils.classNameToJar(classLoader));
    }

    @NotNull
    private static Function<String, File> classNameToJar(ClassLoader classLoader) {
        return className -> {
            try {
                Class<?> aClass = classLoader.loadClass((String)className);
                CodeSource codeSource = aClass.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    throw new NullPointerException("Unknown code source for " + String.valueOf(aClass));
                }
                return new File(codeSource.getLocation().toURI());
            }
            catch (ClassNotFoundException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

