/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox.internal;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashSet;

public class InternalSecurityManager
extends SecurityManager {
    private static final RuntimePermission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private static final RuntimePermission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    private HashSet<String> restrictedPackages = new HashSet();
    private boolean inThreadGroupCheck = false;

    public InternalSecurityManager() {
        this.reset();
    }

    public void reset() {
        this.restrictedPackages.clear();
        AccessController.doPrivileged(() -> {
            Enumeration<?> e = System.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String value;
                String name = (String)e.nextElement();
                if (name == null || !name.startsWith("package.restrict.access.") || (value = System.getProperty(name)) == null || !value.equalsIgnoreCase("true")) continue;
                String pkg = name.substring(24);
                this.restrictedPackages.add(pkg);
            }
            return null;
        });
    }

    protected boolean inThreadGroup(ThreadGroup g) {
        return this.getThreadGroup().parentOf(g);
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    @Override
    public void checkAccess(Thread t) {
        if (t.getState() != Thread.State.TERMINATED && !this.inThreadGroup(t)) {
            this.checkPermission(MODIFY_THREAD_PERMISSION);
        }
    }

    @Override
    public synchronized void checkAccess(ThreadGroup g) {
        if (this.inThreadGroupCheck) {
            this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                this.inThreadGroupCheck = true;
                if (!this.inThreadGroup(g)) {
                    this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
                }
            }
            finally {
                this.inThreadGroupCheck = false;
            }
        }
    }

    @Override
    public void checkPackageAccess(String pkgname) {
        super.checkPackageAccess(pkgname);
        for (String pkg : this.restrictedPackages) {
            if (!pkgname.equals(pkg) && !pkgname.startsWith(pkg + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + pkgname));
        }
    }
}

