/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.maven.sandbox.AccessControlContextHackcessor;
import com.atlassian.bamboo.specs.maven.sandbox.HighPrivilegeThreadPermissionVerifier;
import com.atlassian.bamboo.specs.maven.sandbox.PrivilegedThreads;
import com.atlassian.bamboo.specs.maven.sandbox.ThreadPermissionVerifier;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BambooSpecsSecurityManager
extends SecurityManager {
    private static final String DEBUG_MODE = System.getProperty("specs.security.manager.debug");
    private final Set<Thread> threadsBeingChecked = ConcurrentHashMap.newKeySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Permission perm) {
        if (!this.threadsBeingChecked.add(Thread.currentThread())) {
            return;
        }
        try {
            Collection<ProtectionDomain> context = AccessControlContextHackcessor.getContext(this.getClass());
            if (context.isEmpty()) {
                BambooSpecsSecurityManager.log("Allowing privileged call: " + perm);
                return;
            }
            try {
                PrivilegedThreads.getThreadPermissionChecker().checkPermission(perm);
            }
            catch (AccessControlException e) {
                BambooSpecsSecurityManager.log("Access denied: " + perm);
                throw e;
            }
        }
        finally {
            this.threadsBeingChecked.remove(Thread.currentThread());
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        PrivilegedThreads.getThreadPermissionChecker().checkPermission(perm, context);
    }

    @Override
    public void checkAccess(Thread t) {
        super.checkAccess(t);
        throw new AccessControlException("Access to threads is not permitted");
    }

    public static void setPermissionCheckers(Map<Thread, ThreadPermissionVerifier> specializedVerifiers, ThreadPermissionVerifier defaultVerifier) {
        HashMap<Thread, ThreadPermissionVerifier> specializedVerifiersAndCurrentThread = new HashMap<Thread, ThreadPermissionVerifier>(specializedVerifiers);
        specializedVerifiersAndCurrentThread.put(Thread.currentThread(), HighPrivilegeThreadPermissionVerifier.INSTANCE);
        PrivilegedThreads.setThreadPermissionCheckers(specializedVerifiersAndCurrentThread, defaultVerifier);
    }

    static void log(String s) {
        if (DEBUG_MODE != null) {
            System.out.println(s);
        }
    }
}

